/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.DependencyCustomization;
import ch.e2e.builder.compiler.uml.DependencySupplierDefinition;
import ch.e2e.builder.compiler.uml.Documentation;
import ch.e2e.builder.compiler.uml.Name;
import ch.e2e.builder.compiler.uml.OperationDefinition;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.PropertyDefinition;
import ch.e2e.builder.compiler.uml.PropertyDefinitionComparator;
import ch.e2e.builder.compiler.uml.PropertyGroup;
import ch.e2e.resource.ImageLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;

public class Customization {
    public static PropertyDefinitionComparator propertyComparator = new PropertyDefinitionComparator();
    public static PropertyGroupComparator propertyGroupComparator = new PropertyGroupComparator();
    private HashMap<String, OperationDefinition> operationDefinitions = new HashMap();
    private ArrayList<BridgeStereotype> children;
    private TreeMap<PropertyGroup, TreeSet<PropertyDefinition>> propertyGroups = new TreeMap(propertyGroupComparator);
    private Name elementName;
    private Documentation elementDescription;
    private HashMap<String, Object> properties;
    private HashMap<String, ArrayList<Object>> propertyDependencies;
    private ArrayList<BridgeStereotype> bridgeDependencies;
    private Icon icon;

    public Customization() {
        TreeSet<PropertyDefinition> groupList = new TreeSet<PropertyDefinition>(propertyComparator);
        PropertyGroup group = new PropertyGroup("0:Standard");
        this.propertyGroups.put(group, groupList);
        this.children = new ArrayList();
        this.properties = new HashMap();
        this.propertyDependencies = new HashMap();
        this.bridgeDependencies = new ArrayList();
    }

    protected Customization(Name elementName, Documentation elementDescription, Icon icon) {
        this();
        this.elementName = elementName;
        this.elementDescription = elementDescription;
        this.icon = icon;
    }

    public void append(Customization customization) {
        if (customization != null) {
            for (OperationDefinition definition : customization.operationDefinitions.values()) {
                if (this.operationDefinitions.containsKey(definition.getName().getDefault())) continue;
                this.operationDefinitions.put(definition.getName().getDefault(), definition);
            }
            for (PropertyGroup group : customization.propertyGroups.keySet()) {
                TreeSet<PropertyDefinition> groupList = this.propertyGroups.get(group);
                if (groupList == null) {
                    groupList = new TreeSet<PropertyDefinition>(propertyComparator);
                    this.propertyGroups.put(group, groupList);
                }
                groupList.addAll((Collection<PropertyDefinition>)customization.propertyGroups.get(group));
            }
            for (BridgeStereotype child : customization.bridgeDependencies) {
                if (this.bridgeDependencies.contains(child)) continue;
                this.bridgeDependencies.add(child);
            }
            for (String dependency : customization.propertyDependencies.keySet()) {
                ArrayList<Object> dependencies = this.propertyDependencies.get(dependency);
                if (dependencies == null) {
                    dependencies = new ArrayList();
                    this.propertyDependencies.put(dependency, dependencies);
                }
                for (Object o : customization.propertyDependencies.get(dependency)) {
                    if (dependencies.contains(o)) continue;
                    dependencies.add(o);
                }
            }
        }
    }

    public ArrayList<BridgeStereotype> getChildren() {
        return this.children;
    }

    public void addChild(BridgeStereotype stereotype) {
        if (stereotype != null) {
            this.children.add(stereotype);
        }
    }

    public void addProperty(String name, Object value) {
        if (name.equals("icon")) {
            this.icon = ImageLoader.loadIcon((String)((String)value), (boolean)false, (ClassLoader)this.getClass().getClassLoader());
        } else {
            this.properties.put(name, value);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void addPropertyGroup(String propertyGroup) {
        PropertyGroup group = new PropertyGroup(propertyGroup);
        TreeSet<PropertyDefinition> groupList = this.propertyGroups.get(group);
        if (groupList == null) {
            groupList = new TreeSet<PropertyDefinition>(propertyComparator);
            this.propertyGroups.put(group, groupList);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public HashMap<String, OperationDefinition> getOperationDefinitions() {
        return this.operationDefinitions;
    }

    public boolean isOperationAllowed(String name) {
        return this.operationDefinitions.containsKey(name) || this.operationDefinitions.containsKey("ANY");
    }

    public Set<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups.keySet();
    }

    public TreeMap<PropertyGroup, TreeSet<PropertyDefinition>> getPropertyGroupsMap() {
        return this.propertyGroups;
    }

    public TreeSet<PropertyDefinition> getPropertyGroup(PropertyGroup key) {
        return this.propertyGroups.get(key);
    }

    public void addPropertyDefinition(PropertyDefinition property) {
        PropertyGroup group = property.getGroup() == null ? new PropertyGroup("0:Standard") : new PropertyGroup(property.getGroup());
        TreeSet<PropertyDefinition> groupList = this.propertyGroups.get(group);
        if (groupList == null) {
            groupList = new TreeSet<PropertyDefinition>(propertyComparator);
            this.propertyGroups.put(group, groupList);
        }
        groupList.add(property);
    }

    public boolean hasPropertyDefinition(String propertyName) {
        boolean result = false;
        Iterator<TreeSet<PropertyDefinition>> treeset = this.propertyGroups.values().iterator();
        while (treeset.hasNext() && !result) {
            TreeSet<PropertyDefinition> set = treeset.next();
            Iterator<PropertyDefinition> definitions = set.iterator();
            while (definitions.hasNext() && !result) {
                PropertyDefinition definition = definitions.next();
                result = definition.getName().equals(propertyName);
            }
        }
        return result;
    }

    public PropertyDefinition getPropertyDefinition(String propertyName) {
        PropertyDefinition result = null;
        Iterator<TreeSet<PropertyDefinition>> treeset = this.propertyGroups.values().iterator();
        while (treeset.hasNext() && result == null) {
            TreeSet<PropertyDefinition> set = treeset.next();
            Iterator<PropertyDefinition> definitions = set.iterator();
            while (definitions.hasNext() && result == null) {
                PropertyDefinition definition = definitions.next();
                if (!definition.getName().equals(propertyName)) continue;
                result = definition;
            }
        }
        return result;
    }

    public OperationDefinition getOperationDefinition(String name) {
        return this.operationDefinitions.get(name);
    }

    public void addOperationDefinition(OperationDefinition operationDefinition) {
        this.operationDefinitions.put(operationDefinition.getName().getDefault(), operationDefinition);
    }

    public Name getElementName() {
        return this.elementName;
    }

    public void setElementName(Name elementName) {
        this.elementName = elementName;
    }

    public Documentation getElementDescription() {
        return this.elementDescription;
    }

    public void setElementDescription(Documentation elementDescription) {
        this.elementDescription = elementDescription;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void addBridgeDependencies(List<BridgeStereotype> dependencies) {
        this.bridgeDependencies.addAll(dependencies);
    }

    public void addBridgeDependency(BridgeStereotype dependency) {
        this.bridgeDependencies.add(dependency);
    }

    public ArrayList<BridgeStereotype> getBridgeDependencies() {
        return this.bridgeDependencies;
    }

    public boolean hasBridgeDependencies() {
        return this.bridgeDependencies.size() > 0;
    }

    public ArrayList<DependencySupplierDefinition> getDependencySuppliers() {
        ArrayList<DependencySupplierDefinition> suppliers = new ArrayList<DependencySupplierDefinition>();
        for (BridgeStereotype stereotype : this.bridgeDependencies) {
            if (!(stereotype.getCustomization() instanceof DependencyCustomization)) {
                boolean bl = false;
                continue;
            }
            suppliers.addAll(((DependencyCustomization)stereotype.getCustomization()).getSupplierDefinitions());
        }
        return suppliers;
    }

    public ArrayList<BridgeStereotype> getRequiredBridgeDependencies() {
        ArrayList<BridgeStereotype> result = new ArrayList<BridgeStereotype>();
        for (BridgeStereotype stereotype : this.bridgeDependencies) {
            if (!stereotype.isRequired()) continue;
            result.add(stereotype);
        }
        return result;
    }

    public void addPropertyDependency(String dependency, Object dependencyValue) {
        ArrayList<Object> dependencies = this.propertyDependencies.get(dependency);
        if (dependencies == null) {
            dependencies = new ArrayList();
            this.propertyDependencies.put(dependency, dependencies);
        }
        dependencies.add(dependencyValue);
    }

    public boolean hasPropertyDependencies() {
        return this.propertyDependencies.size() > 0;
    }

    public boolean checkPropertyDependency(Property property) {
        ArrayList<Object> dependencies = this.propertyDependencies.get(property.getName());
        return dependencies != null && dependencies.contains(property.getValue());
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Map<String, PropertyDefinition> getPropertyDefinitions() {
        HashMap<String, PropertyDefinition> result = new HashMap<String, PropertyDefinition>();
        for (TreeSet<PropertyDefinition> values : this.propertyGroups.values()) {
            for (PropertyDefinition value : values) {
                result.put(value.getName(), value);
            }
        }
        return result;
    }

    public static class PropertyGroupComparator
    implements Comparator<PropertyGroup> {
        @Override
        public int compare(PropertyGroup o1, PropertyGroup o2) {
            int result = 0;
            if (o1.getIndex() > o2.getIndex()) {
                result = 1;
            } else if (o1.getIndex() < o2.getIndex()) {
                result = -1;
            }
            if (result == 0) {
                result = o1.getKey().compareToIgnoreCase(o2.getKey());
            }
            return result;
        }
    }
}

