/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.resource.ImageLoader;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ComponentList
extends ClassifierElement {
    private static final int TYPE_OFFSET = 100000;
    public static final int CONFIGURATIONS = 100000;
    public static final int BACKEND_SERVICES = 100001;
    public static final int PROXY_SERVICES = 100002;
    private boolean selectable = false;
    private String name;
    private int treeType;

    public ComponentList(BridgeStereotype stereotype, String name, int treeType, UmlElement parent, Helpers helpers) {
        super(stereotype, helpers);
        this.setParent(parent);
        this.treeType = treeType;
        this.name = name;
    }

    @Override
    public int getType() {
        return this.treeType;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ComponentList) {
            result = this.equals((ComponentList)o);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        ImageIcon result = null;
        switch (this.treeType) {
            case 100001: {
                result = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/component.diagram.backendservices.icon.gif", (boolean)true);
                break;
            }
            case 100000: {
                result = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/ui.deployment.icon.gif", (boolean)true);
                break;
            }
            case 100002: {
                result = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/images/component.diagram.proxyservices.icon.gif", (boolean)true);
            }
        }
        return result;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public boolean isChildRequired() {
        return this.treeType == 100000 && super.isChildRequired();
    }

    private boolean equals(ComponentList other) {
        return other.treeType == this.treeType && other.name.equals(this.name);
    }
}

