/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.ArrayAccessException;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeParameterDefinition;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.MultiplicityElement;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.RightListElement;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlElement;
import javax.swing.Icon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeParameter
extends UmlElement
implements RightListElement,
Comparable,
TypedElement,
MultiplicityElement {
    private BridgeClass type;
    private Direction direction;
    private boolean required;
    private BridgeParameterDefinition definition;
    private Multiplicity multiplicity;

    public BridgeParameter(BridgeParameterDefinition definition, Helpers helpers) {
        this(definition.getName(), definition.getTypeClass(), definition.getDirection(), definition.getStereotype(), helpers);
        this.definition = definition;
        this.required = definition.isRequired();
        for (Property property : definition.getProperties().values()) {
            this.addProperty(property);
        }
    }

    public BridgeParameter(String name, BridgeClass type, Direction direction, boolean required, Helpers helpers) {
        this(name, type, direction, helpers);
        this.required = required;
    }

    public BridgeParameter(String name, Direction direction, Comment comment, Helpers helpers) {
        this(name, null, direction, comment, helpers);
    }

    public BridgeParameter(String name, BridgeClass type, Direction direction, Helpers helpers) {
        this(name, type, direction, new Comment("", helpers), helpers);
    }

    public BridgeParameter(String name, BridgeClass type, Direction direction, Comment comment, Helpers helpers) {
        super(name, comment, helpers);
        this.type = type;
        this.direction = direction;
        this.required = false;
    }

    public BridgeParameter(String name, BridgeClass type, Direction direction, BridgeStereotype stereotype, Helpers helpers) {
        super(name, stereotype, helpers);
        this.type = type;
        this.direction = direction;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (this.direction.equals((Object)Direction.RETURN) && (name == null || name.length() == 0)) {
            name = "return";
        }
        return name;
    }

    @Override
    public BridgeClass getTypeClass() {
        return this.isArray() ? this.getHelpers().getElementHelper().findType("Base Types/Array") : this.type;
    }

    @Override
    public void setTypeClass(BridgeClass type) {
        this.type = type;
    }

    @Override
    public BridgeClass getArrayElementType() throws ArrayAccessException {
        if (!this.isArray()) {
            throw new ArrayAccessException();
        }
        return this.type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public BridgeParameterDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(BridgeParameterDefinition definition) {
        this.definition = definition;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean multipleInstancesAllowed() {
        return this.definition.multipleInstancesAllowed();
    }

    @Override
    public boolean isComplete() {
        return this.getName() != null && this.getName().length() > 0 && this.direction != null;
    }

    public boolean isReturnValue() {
        return this.getDirection() == Direction.RETURN;
    }

    @Override
    public Icon getIcon() {
        return this.direction == null ? (this.definition == null ? null : this.definition.getIcon()) : BridgeParameterDefinition.getIcon(this.direction);
    }

    @Override
    public String toDisplayText() {
        return (this.getName() != null ? this.getName() : "???") + (this.type == null ? "" : ": " + this.type) + (this.getTypeStereotype() == null ? "" : " <<" + this.getTypeStereotype() + ">>");
    }

    public String getTypeStereotype() {
        String stereotype = null;
        if (this.definition != null) {
            stereotype = this.definition.getTypeStereotype();
        }
        return stereotype;
    }

    @Override
    public int compareTo(Object o) {
        int result = 0;
        if (o instanceof BridgeParameter) {
            result = this.getName().compareToIgnoreCase(((BridgeParameter)o).getName());
        }
        return result;
    }

    @Override
    public String getBaseclass() {
        return "Parameter";
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element element = this.createXMIElement("ownedParameter", ownerDocument, xmiIDFactory);
        element.setAttribute("name", super.getName());
        element.setAttribute("direction", Direction.toString(this.direction));
        if (this.type != null) {
            if (this.checkModule(this.type.getModule())) {
                element.setAttribute("type", this.type.getXmiID());
            } else {
                Element typeElement = this.createModuleLink(this.type, "type", ownerDocument, xmiIDFactory);
                element.appendChild(typeElement);
            }
        }
        if (this.multiplicity != null) {
            this.multiplicity.appendToXMI(element, xmiIDFactory);
        }
        return element;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return this.toXMI(ownerDocument, xmiIDFactory);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o != null && o instanceof BridgeParameter) {
            BridgeParameter other = (BridgeParameter)o;
            result = (other.getName() == null && this.getName() == null || other.getName() != null && other.getName().equals(this.getName())) && (other.type == null && this.type == null || other.type != null && other.type.equals(this.type)) && (other.direction == null && this.direction == null || other.direction != null && other.direction.equals((Object)this.direction)) && other.getXmiID().equals(this.getXmiID());
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getSignature() {
        String signature;
        if (this.isArray()) {
            try {
                BridgeClass clazz = this.getArrayElementType();
                signature = (clazz == null ? " : [no type}" : clazz.getSignature()) + "[]";
            }
            catch (ArrayAccessException e) {
                throw new IllegalStateException(e);
            }
        } else {
            BridgeClass clazz = this.getTypeClass();
            signature = clazz == null ? " : [no type]" : clazz.getSignature();
        }
        return this.getName() + signature;
    }

    @Override
    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    @Override
    public void setMultiplicity(Multiplicity multiplicity) {
        this.multiplicity = multiplicity;
    }

    @Override
    public boolean isArray() {
        return this.multiplicity != null && this.multiplicity.multipleInstancesAllowed();
    }

    @Override
    public UmlElement[] getAdditionalElements() {
        return new UmlElement[]{this.type};
    }

    public boolean usesPin() {
        return this.type != null;
    }

    public boolean isSimpleType() {
        return this.getHelpers().getElementHelper().isSimpleType(this.type);
    }

    public boolean isInputParameter() {
        return this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.VALUE_IN);
    }

    public BridgeParameter createCopy(Module module) {
        BridgeParameter result = new BridgeParameter(this.getName(), this.getTypeClass(), this.getDirection(), this.getHelpers());
        this.copyStereotypesAndProperties(result);
        result.setModule(module);
        return result;
    }
}

