/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgePackage
extends UmlElement {
    private String key;
    private ArrayList<BridgePackage> packages = new ArrayList();

    public BridgePackage(String name, String xmiID, Helpers helpers) {
        super(name, new Comment("", helpers), null, helpers);
        this.setXmiID(xmiID);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setStereotype(BridgeStereotype stereotype) {
        super.setStereotype(stereotype);
    }

    @Override
    public void createReference() throws Exception {
        this.getHelpers().getPackagesFactory().createReference(this);
    }

    public void addPackage(BridgePackage childPackage) {
        if (!this.packages.contains(childPackage)) {
            childPackage.setOwningPackage(this);
            this.packages.add(childPackage);
        }
    }

    public BridgePackage getPackage(String name) {
        BridgePackage result = null;
        int length = this.packages.size();
        for (int i = 0; i < length && result == null; ++i) {
            BridgePackage child = this.packages.get(i);
            result = child.getName().equals(name) ? child : null;
        }
        return result;
    }

    public List<BridgePackage> getPackages() {
        return this.packages;
    }

    @Override
    public String getBaseclass() {
        return "Package";
    }

    public String getPath() {
        StringBuffer path = new StringBuffer();
        for (BridgePackage parent = this; parent != null; parent = parent.getOwningPackage()) {
            if (path.length() == 0) {
                path.insert(0, parent.getName());
                continue;
            }
            path.insert(0, parent.getName() + '/');
        }
        return path.toString();
    }

    public Element toXMI(Document ownerDocument, Module module, XmiIDFactory xmiIDFactory) {
        Element result = this.checkModule(module) ? super.toXMI(ownerDocument, xmiIDFactory) : this.toXMI(ownerDocument, xmiIDFactory);
        return result;
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = this.getModule() == null ? super.toXMI(ownerDocument, xmiIDFactory) : this.createModuleLink(ownerDocument, xmiIDFactory);
        return result;
    }

    @Override
    protected void appendDescription(Element element, Document ownerDocument, XmiIDFactory xmiIDFactory) {
        if (this.getDescription() != null && this.getDescription().getText().length() > 0) {
            super.appendDescription(element, ownerDocument, xmiIDFactory);
        }
    }
}

