/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.ArrayAccessException;
import ch.e2e.builder.compiler.uml.BridgeAssociation;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.ElementWithVisibility;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.MultiplicityElement;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.compiler.uml.Value;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeAttribute
extends UmlElement
implements TypedElement,
MultiplicityElement,
ElementWithVisibility {
    private BridgeClass type;
    private Multiplicity multiplicity;
    private BridgeAssociation association;
    private Value defaultValue;
    private String visibility = "public";

    public BridgeAttribute(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
        this.type = BridgeClass.getUntypedClass(helpers);
        this.multiplicity = Multiplicity.getEmptyValue();
        this.defaultValue = Value.getEmptyValue();
    }

    public BridgeAttribute(String name, BridgeStereotype stereotype, Helpers helpers) {
        this(name, null, stereotype, helpers);
    }

    public BridgeAttribute(BridgeStereotype stereotype, Helpers helpers) {
        this(null, null, stereotype, helpers);
    }

    @Override
    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    @Override
    public void setMultiplicity(Multiplicity multiplicity) {
        this.multiplicity = multiplicity;
    }

    @Override
    public BridgeClass getTypeClass() {
        return this.isArray() ? this.getHelpers().getElementHelper().findType("Base Types/Array") : this.type;
    }

    @Override
    public void setTypeClass(BridgeClass type) {
        this.type = type;
    }

    @Override
    public BridgeClass getArrayElementType() throws ArrayAccessException {
        if (!this.isArray()) {
            throw new ArrayAccessException();
        }
        return this.type;
    }

    public BridgeAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(BridgeAssociation association) {
        this.association = association;
    }

    @Override
    public String getBaseclass() {
        return "Property";
    }

    public void setDefaultValue(Object value, String type) {
        this.defaultValue = new Value("defaultValue", type);
        this.defaultValue.setValue(value);
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element element = super.toXMI(ownerDocument, xmiIDFactory);
        if (this.association != null) {
            element.setAttribute("association", this.association.getXmiID());
        }
        if (this.type.getModule() == null) {
            this.type.setModule(this.getModule());
        }
        if (this.checkModule(this.type.getModule())) {
            element.setAttribute("type", this.type.getXmiID());
        } else {
            Element typeElement = this.createModuleLink(this.type, "type", ownerDocument, xmiIDFactory);
            element.appendChild(typeElement);
        }
        this.multiplicity.appendToXMI(element, xmiIDFactory);
        this.defaultValue.appendToXMI(element, xmiIDFactory);
        return element;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return this.toXMI(ownerDocument, xmiIDFactory);
    }

    @Override
    protected String getXMIElementName() {
        return "ownedAttribute";
    }

    @Override
    public boolean isArray() {
        return this.multiplicity != null && this.multiplicity.multipleInstancesAllowed();
    }

    @Override
    public String getSignature() {
        String signature = this.getName() + (this.type == null ? " : [no type]" : this.type.getSignature());
        return this.isArray() ? signature + "[]" : signature;
    }

    @Override
    public UmlElement[] getAdditionalElements() {
        return new UmlElement[]{this.type, this.association};
    }

    @Override
    public List<Module> getAllUsedModules() {
        List<Module> modules = super.getAllUsedModules();
        if (this.association != null && this.association.getModule() != null && !modules.contains(this.association.getModule())) {
            modules.add(this.association.getModule());
        }
        return modules;
    }

    @Override
    public List<UmlElement> getAllChildrenUsingOtherModule() {
        List<UmlElement> modules = super.getAllChildrenUsingOtherModule();
        if (this.association != null && this.association.getModule() != null && !modules.contains(this.association)) {
            modules.add(this.association);
        }
        return modules;
    }

    @Override
    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    @Override
    public String getVisibility() {
        return this.visibility;
    }
}

