/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.ActivityFlow;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActivityNode
extends UmlElement {
    private ArrayList<ActivityFlow> outgoings = new ArrayList();
    private ArrayList<ActivityFlow> incomings = new ArrayList();

    public ActivityNode(String name, Helpers helpers) {
        super(name, (Comment)null, helpers);
    }

    public void addIncoming(ActivityFlow incoming) {
        this.incomings.add(incoming);
    }

    public void removeIncoming(ActivityFlow incoming) {
        this.incomings.remove(incoming);
    }

    public void addOutgoing(ActivityFlow outgoing) {
        this.outgoings.add(outgoing);
    }

    public void removeOutgoing(ActivityFlow outgoing) {
        this.outgoings.remove(outgoing);
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element outgoing;
        Element result = super.toXMI(ownerDocument, xmiIDFactory);
        for (ActivityFlow activityFlow : this.outgoings) {
            outgoing = ownerDocument.createElement("outgoing");
            outgoing.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", activityFlow.getXmiID());
            result.appendChild(outgoing);
        }
        for (ActivityFlow activityFlow : this.incomings) {
            outgoing = ownerDocument.createElement("incoming");
            outgoing.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", activityFlow.getXmiID());
            result.appendChild(outgoing);
        }
        return result;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return this.toXMI(ownerDocument, xmiIDFactory);
    }

    @Override
    protected String getXMIElementName() {
        return "node";
    }
}

