/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.ActivityFinalNode;
import ch.e2e.builder.compiler.uml.ActivityFlow;
import ch.e2e.builder.compiler.uml.ActivityInitialNode;
import ch.e2e.builder.compiler.uml.ActivityNode;
import ch.e2e.builder.compiler.uml.ActivityParameterNode;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.CallOperationAction;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Pin;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Activity
extends UmlElement {
    private BridgeOperation specification;

    public Activity(String name, Comment comment, Helpers helpers) {
        super(name, comment, helpers);
    }

    public Activity(BridgeOperation specification, Helpers helpers) {
        super(specification.getName(), (Comment)null, helpers);
        this.specification = specification;
        ActivityInitialNode initialNode = new ActivityInitialNode(helpers);
        this.addChild(initialNode);
        ActivityFinalNode finalNode = new ActivityFinalNode(this.getHelpers());
        ActivityFlow flow = new ActivityFlow("ControlFlow", initialNode, finalNode, helpers);
        initialNode.addOutgoing(flow);
        finalNode.addIncoming(flow);
        this.addChild(flow);
        this.addChild(finalNode);
    }

    public void appendNode(ActivityNode node) {
        ActivityFlow lastFlow = (ActivityFlow)this.getAllChildren().get(this.getChildCount() - 2);
        ActivityFinalNode finalNode = (ActivityFinalNode)this.getAllChildren().get(this.getChildCount() - 1);
        finalNode.removeIncoming(lastFlow);
        lastFlow.setTarget(node);
        node.addIncoming(lastFlow);
        this.getAllChildren().add(this.getChildCount() - 2, node);
        ActivityFlow flow = new ActivityFlow("ControlFlow", node, finalNode, this.getHelpers());
        node.addOutgoing(flow);
        finalNode.addIncoming(flow);
        this.getAllChildren().add(this.getChildCount() - 2, flow);
    }

    public void addParameter(ActivityParameterNode parameter, CallOperationAction action, Direction direction) {
        List<Pin> pins = action.getPins(parameter.getBridgeParameter());
        if (pins == null || pins.size() == 0) {
            if (direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.INOUT)) {
                ActivityFlow in = new ActivityFlow("ObjectFlow", parameter, action, this.getHelpers());
                action.addIncoming(in);
            }
            if (direction.equals((Object)Direction.OUT) || direction.equals((Object)Direction.RETURN) || direction.equals((Object)Direction.INOUT)) {
                ActivityFlow out = new ActivityFlow("ObjectFlow", action, parameter, this.getHelpers());
                action.addOutgoing(out);
            }
        }
        for (Pin pin : pins) {
            if (direction.equals((Object)Direction.IN) || direction.equals((Object)Direction.INOUT) && pin.isInputPin()) {
                ActivityFlow in = new ActivityFlow("ObjectFlow", parameter, pin, this.getHelpers());
                pin.addIncoming(in);
                parameter.addOutgoing(in);
                this.addChild(in);
            }
            if (!direction.equals((Object)Direction.OUT) && !direction.equals((Object)Direction.RETURN) && (!direction.equals((Object)Direction.INOUT) || !pin.isOutputPin())) continue;
            ActivityFlow out = new ActivityFlow("ObjectFlow", pin, parameter, this.getHelpers());
            pin.addOutgoing(out);
            parameter.addIncoming(out);
            this.addChild(out);
        }
    }

    @Override
    public String getBaseclass() {
        return "Activity";
    }

    @Override
    public Element toXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element result = super.toXMI(ownerDocument, xmiIDFactory);
        result.setAttribute("specification", this.specification.getXmiID());
        return result;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        return this.toXMI(ownerDocument, xmiIDFactory);
    }

    @Override
    public int getChildCount() {
        return this.getAllChildren().size();
    }

    @Override
    protected String getXMIElementName() {
        return "ownedBehavior";
    }
}

