/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.build.BuildProperties;
import ch.e2e.builder.compiler.net.HTTPAction;
import ch.e2e.builder.compiler.net.Logging;
import ch.e2e.builder.compiler.net.Login;
import ch.e2e.builder.compiler.net.LoginFailedException;
import ch.e2e.builder.compiler.net.PageNotFoundException;
import ch.e2e.builder.compiler.net.UnknownHttpException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LoginAction
extends HTTPAction {
    private static final String usernameKey;
    private static final String passwordKey;
    private String cookie;
    private String requestedUrl;
    private boolean used = false;
    private Login login;

    public boolean doLogin(Login login, String requestedPage) throws IOException, LoginFailedException {
        if (this.used) {
            throw new IllegalStateException("An instance of LoginAction can only be used one time to login.");
        }
        this.login = login;
        this.requestedUrl = login.getUrl() + "/" + requestedPage;
        Logging.logger.info("requestedUrl = " + this.requestedUrl);
        if (!this.checkLogin()) {
            throw new LoginFailedException();
        }
        boolean result = true;
        this.used = true;
        return result;
    }

    @Override
    protected Map<String, String> getParameters() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put(usernameKey, this.login.getUsername());
        parameter.put(passwordKey, this.login.getPassword());
        return parameter;
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("X-Bridge", "return-xml");
        return properties;
    }

    @Override
    protected String getRequestUrl() {
        return this.requestedUrl;
    }

    private boolean checkLogin() throws IOException {
        boolean result = false;
        HTTPAction.Response response = this.doRequest();
        switch (response.getStatusCode()) {
            case 302: {
                this.cookie = response.getCondensedHeaderValue("Set-Cookie");
                String nextPage = response.getCondensedHeaderValue("Location");
                result = nextPage != null && this.requestedUrl.endsWith(nextPage);
                break;
            }
            case 200: {
                Logging.logger.fine(response.getResponseBodyAsString());
                break;
            }
            case 401: {
                break;
            }
            case 404: {
                throw new PageNotFoundException(this.requestedUrl);
            }
            default: {
                throw new UnknownHttpException(response.getStatusText(), response.getStatusCode());
            }
        }
        return result;
    }

    public String getCookie() {
        return this.cookie;
    }

    static {
        BuildProperties buildProperties = BuildProperties.getInstance();
        usernameKey = buildProperties.getString("deploy.login.username.key");
        passwordKey = buildProperties.getString("deploy.login.password.key");
    }
}

