/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.LoginAction;
import ch.e2e.builder.compiler.net.LoginFailedException;
import java.io.IOException;
import javax.ws.rs.core.UriBuilder;

public class Login {
    private String username;
    private String host;
    private String password;
    private String url;
    private String cookie;
    private String bearer;

    public Login(String user, String password, String host, int port) {
        this(user, password, "https", host, port, "");
    }

    public Login(String bearer, String protocol, String host, int port, String pathPrefix) {
        this(protocol, host, port, pathPrefix);
        this.bearer = bearer;
    }

    public Login(String user, String password, String protocol, String host, int port, String pathPrefix) {
        this(protocol, host, port, pathPrefix);
        this.password = password;
        this.username = user;
    }

    public Login(String protocol, String host, int port, String pathPrefix) {
        this.host = host;
        this.url = UriBuilder.fromPath((String)pathPrefix.trim()).scheme(protocol).host(host).port(port < 1 ? -1 : port).toString();
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getBearer() {
        return this.bearer;
    }

    public void setBearer(String bearer) {
        this.bearer = bearer;
    }

    public void clearPassword() {
        System.setProperty("ch.e2e.builder.compiler..webapp.admin.password", "");
    }

    public void askForPassword() {
        this.setPassword(null);
    }

    public String doLogin(String requestedPage) throws IOException, LoginFailedException {
        String result = null;
        if (this.password != null && this.password.length() > 0) {
            LoginAction loginAction = new LoginAction();
            try {
                if (loginAction.doLogin(this, requestedPage)) {
                    result = loginAction.getCookie();
                }
            }
            catch (LoginFailedException lfEx) {
                this.clearPassword();
                throw lfEx;
            }
        }
        return result;
    }
}

