/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.HTTPAction;
import ch.e2e.builder.compiler.net.Login;
import ch.e2e.builder.compiler.net.LoginFailedException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class BridgeServiceAction
extends HTTPAction {
    public static final String BRIDGE_SERVICE_KEY = "instance";
    public static final String BRIDGE_NODE_KEY = "node";
    public static final String ACTION_START = "action_START";
    public static final String ACTION_STOP = "action_STOP";
    protected static final String CONFIGURATION_REQUEST_START_X_UML = "admin/Console/BridgeInstanceConfigurationCmdStart";
    protected static final String CONFIGURATION_REQUEST_STOP_X_UML = "admin/Console/BridgeInstanceConfigurationCmdStop";
    protected static final String CONFIGURATION_REQUEST_START_NODE_JS = "admin/Console/nodejs/service/Configuration";
    protected static final String CONFIGURATION_REQUEST_STOP_NODE_JS = "admin/Console/nodejs/service/Configuration";
    protected static final String CONFIGURATION_REQUEST_START_JAVA = "admin/Console/java/service/Configuration";
    protected static final String CONFIGURATION_REQUEST_STOP_JAVA = "admin/Console/java/service/Configuration";
    private final Map<String, String> parameters = new HashMap<String, String>();
    private String requestUrl;
    private String cookie;

    public String configureService(String service, String node, Login login, int timeout) throws IOException, LoginFailedException {
        this.cookie = login.doLogin("admin/Console/Welcome");
        this.parameters.clear();
        this.parameters.put(BRIDGE_SERVICE_KEY, service);
        this.parameters.put(BRIDGE_NODE_KEY, node);
        this.parameters.put(this.getAction(), "submit");
        this.requestUrl = login.getUrl() + '/' + this.getServiceRequest();
        return this.doRequest(timeout).getResponseBodyAsString();
    }

    protected abstract String getServiceRequest();

    @Override
    protected Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    protected boolean getRedirect() {
        return false;
    }

    @Override
    protected Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Cookie", this.cookie);
        properties.put("X-Bridge", "return-xml");
        return properties;
    }

    @Override
    protected String getRequestUrl() {
        return this.requestUrl;
    }

    protected abstract String getAction();
}

