/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.error;

import ch.e2e.builder.compiler.error.DefaultCompilerError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaCompileError
extends DefaultCompilerError {
    public static final String JAVA_COMPILE_ERROR_CODE = "error.java.compile";
    private String details;

    public JavaCompileError(String details) {
        super(JAVA_COMPILE_ERROR_CODE, null);
        this.details = details;
    }

    public JavaCompileError(Element errorElement) {
        super(errorElement);
        NodeList detailsList = errorElement.getElementsByTagName("Detailmessage");
        if (detailsList != null && detailsList.getLength() > 0) {
            this.details = detailsList.item(0).hasChildNodes() ? detailsList.item(0).getFirstChild().getNodeValue() : "";
        }
    }

    @Override
    public int getType() {
        return 1011;
    }

    public Element toNode(Document parent) {
        Element result = super.toNode(parent);
        Element details = parent.createElement("Detailmessage");
        details.appendChild(parent.createTextNode(this.details));
        result.appendChild(details);
        return result;
    }

    public String getDetails() {
        return this.details;
    }
}

