/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.xslt;

import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImportSource;
import ch.e2e.builder.compiler.document.importer.xslt.XSLTImportDataModel;
import ch.e2e.builder.compiler.document.importer.xslt.XSLTScript;
import ch.e2e.builder.compiler.document.importer.xslt.XSLTScriptArchive;
import ch.e2e.builder.compiler.document.importer.xslt.XSLTScriptObject;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.ModelPackage;
import ch.e2e.builder.compiler.uml.UserArtifactTemplate;
import ch.e2e.builder.compiler.uml.UserComponentTemplate;
import org.w3c.dom.Document;

public class XSLTImportSource
extends ImportSource {
    private static final String RESOURCES_PACKAGE = "Component View/Resources";
    private XSLTImportDataModel dataModel;
    private XSLTScriptObject[] scriptObjects;
    private Helpers helpers;

    public XSLTImportSource(XSLTScriptObject[] scriptObjects, String name, Helpers helpers) {
        this.scriptObjects = scriptObjects;
        this.helpers = helpers;
        this.dataModel = new XSLTImportDataModel(name, helpers);
        this.addXSLTScriptObjects(scriptObjects);
    }

    public XSLTScriptObject[] getScriptObjects() {
        return this.scriptObjects;
    }

    public Document getSourceDocument() {
        for (ModelPackage modelPackage : this.dataModel.getModel().getPackages()) {
            this.dataModel.addSharedPackage(modelPackage.getOrigin());
        }
        return this.dataModel.createDocument();
    }

    @Override
    public String getDevelopmentFilename() {
        return null;
    }

    @Override
    public ImportModel getImportModel() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    private void addXSLTScriptObjects(XSLTScriptObject[] allScriptObjects) {
        BridgePackage templates = this.helpers.getPackagesFactory().createPackages("Component View/Templates", this.dataModel.getImportRoot(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        for (XSLTScriptObject scriptObject : allScriptObjects) {
            if (scriptObject instanceof XSLTScriptArchive) {
                this.addXSLTArchive((XSLTScriptArchive)scriptObject, templates);
                continue;
            }
            ClassifierElement scriptClassifier = this.createXSLTScript((XSLTScript)scriptObject);
            UserArtifactTemplate scriptArtifact = new UserArtifactTemplate(scriptObject.getName(), new Comment("", this.helpers), this.helpers.getStereotypeFactory().getStereotype("XSLTScriptFile"), this.helpers);
            scriptArtifact.setClassifier(scriptClassifier);
            scriptArtifact.setOwningPackage(templates);
            this.dataModel.addElement(scriptArtifact);
        }
    }

    private void addXSLTArchive(XSLTScriptArchive scriptArchive, BridgePackage templates) {
        UserComponentTemplate archive = new UserComponentTemplate(scriptArchive.getShortName(), new Comment("", this.helpers), this.helpers.getStereotypeFactory().getStereotype("XSLTArchive"), this.helpers);
        archive.setOwningPackage(templates);
        UserArtifactTemplate artifact = new UserArtifactTemplate(scriptArchive.getName(), new Comment("", this.helpers), this.helpers.getStereotypeFactory().getStereotype("XSLTArchiveFile"), this.helpers);
        artifact.setClassifier(archive);
        artifact.setOwningPackage(templates);
        artifact.setPropertyValueQuietly("deploy", scriptArchive.isDeploy());
        for (XSLTScript xsltScript : scriptArchive.getScripts()) {
            ClassifierElement scriptClassifier = this.createXSLTScript(xsltScript);
            archive.addChild(scriptClassifier);
            UserArtifactTemplate scriptArtifact = new UserArtifactTemplate(xsltScript.getName(), new Comment("", this.helpers), this.helpers.getStereotypeFactory().getStereotype("XSLTScriptFile"), this.helpers);
            artifact.addChild(scriptArtifact);
            scriptArtifact.setClassifier(scriptClassifier);
            this.dataModel.addElement(scriptArtifact);
        }
        this.dataModel.addElement(archive);
        this.dataModel.addElement(artifact);
    }

    private ClassifierElement createXSLTScript(XSLTScript xsltScript) {
        BridgePackage interfacePackage = this.helpers.getPackagesFactory().createPackages(RESOURCES_PACKAGE, this.dataModel.getImportRoot(), this.helpers.getStereotypeFactory().getStereotype("Repository"));
        ClassifierElement script = new ClassifierElement(xsltScript.getShortName(), new Comment("", this.helpers), this.helpers.getStereotypeFactory().getStereotype("XSLTScript"), this.helpers);
        script.setOwningPackage(interfacePackage);
        this.dataModel.addElement(script);
        return script;
    }

    public String toString() {
        String result;
        if (this.scriptObjects.length == 1) {
            result = this.scriptObjects[0].getScriptFile().getName();
        } else {
            StringBuilder resultBuilder = new StringBuilder("[");
            for (XSLTScriptObject scriptObject : this.scriptObjects) {
                if (resultBuilder.length() == 1) {
                    resultBuilder.append(scriptObject.getScriptFile().getName());
                    continue;
                }
                resultBuilder.append(", ").append(scriptObject.getScriptFile().getName());
            }
            resultBuilder.append("]");
            result = resultBuilder.toString();
        }
        return result;
    }
}

