/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.swagger;

import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.builder.compiler.document.importer.swagger.SwaggerImportSource;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import java.io.File;
import java.util.ArrayList;

public class SwaggerImportTransaction
extends ScriptImportTransaction {
    public static final String SWAGGER_IMPORT_SOURCE = "swagger.import.source";
    public static final String SWAGGER_IMPORT_MODEL = "swagger.import.model";
    private final String description;

    public SwaggerImportTransaction(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void doTransaction(ImporterData importerData) {
        SwaggerImportSource swaggerImportSource = (SwaggerImportSource)importerData.getSource(SWAGGER_IMPORT_SOURCE);
        if (swaggerImportSource != null) {
            ImportModel importModel = new ImportModel(importerData.getFilename());
            importModel.setDataModel(swaggerImportSource.getImportDataModel());
            importModel.setModel(swaggerImportSource.getSourceDocument());
            this.printSourceDocument(importModel.getModel(), importModel.getName());
            importerData.addSource(SWAGGER_IMPORT_MODEL, importModel);
            swaggerImportSource.readExtensions(importModel.getDestination());
            ImportModel testImportModel = new ImportModel(swaggerImportSource.getName() + ".swaggerTest");
            testImportModel.setDestination(new File(CompilerConstants.getSourceFolder(), testImportModel.getName() + ".xml"));
            testImportModel.setDataModel(swaggerImportSource.getTestDataModel());
            testImportModel.setModel(swaggerImportSource.getTestSourceDocument());
            this.printSourceDocument(testImportModel.getModel(), testImportModel.getName());
            ArrayList<ImportModel> testModels = new ArrayList<ImportModel>();
            testModels.add(testImportModel);
            if (((Boolean)importerData.getSource("data.key.create.test.model")).booleanValue()) {
                importerData.addSource("test.model.sources", testModels);
            }
            importerData.addSource(IMPORT_DATA_ALIASES, swaggerImportSource.getAliases());
        }
    }
}

