/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.mdbpmn;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.XmiTransformationModelHelper;
import ch.e2e.builder.compiler.document.importer.ExtensionElement;
import ch.e2e.builder.compiler.document.importer.ImportException;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImportTools;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MDBPMNImportTransaction
extends ScriptImportTransaction {
    public static final String MDBPMN_IMPORT_MODELS = "mdbpmn.import.models";
    public static final String MD_BPMN_DOCUMENT_SOURCE = "mdbpmn.document.source";
    private final String description;

    public MDBPMNImportTransaction(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    protected Map<String, Object> getDefaultExtensionParameters() {
        Map<String, Object> result = super.getDefaultExtensionParameters();
        result.put("useMessageEventDefinition", true);
        return result;
    }

    @Override
    protected Map<String, Object> readExtensionsParameters(Element element) {
        HashMap<String, Object> extensionParameters = new HashMap<String, Object>();
        if (element == null) {
            extensionParameters.put("useMessageEventDefinition", false);
        } else {
            try {
                String useMessageEventDefinition = (String)DomUtilities.evaluate((Node)element, (String)"@useMessageEventDefinition", (QName)XPathConstants.STRING);
                if (useMessageEventDefinition != null && !useMessageEventDefinition.equals("")) {
                    extensionParameters.put("useMessageEventDefinition", useMessageEventDefinition.equals("true"));
                } else {
                    extensionParameters.put("useMessageEventDefinition", false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return extensionParameters;
    }

    @Override
    public void doTransaction(ImporterData importerData) {
        if (importerData.getDestination() != null) {
            Map<String, Object> defaultExtensionsParameters = this.getDefaultExtensionParameters();
            for (String key : defaultExtensionsParameters.keySet()) {
                if (this.getTransformParameter(key) != null) continue;
                this.putTransformParameter(key, defaultExtensionsParameters.get(key));
            }
            Document result = null;
            if (importerData.getSource(MD_BPMN_DOCUMENT_SOURCE) instanceof URL) {
                XSLTInput.setImportSource(((URL)importerData.getSource(MD_BPMN_DOCUMENT_SOURCE)).getFile());
                result = this.transform((URL)importerData.getSource(MD_BPMN_DOCUMENT_SOURCE), "mdbpmn2xmi", importerData.getFilename());
            } else {
                try {
                    File file = (File)importerData.getSource(MD_BPMN_DOCUMENT_SOURCE);
                    result = this.transformMDImportDocument(file, importerData.getFilename(), "mdbpmn2xmi");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
                }
            }
            if (result != null) {
                File destination;
                this.printSourceDocument(result, importerData.getFilename());
                List<ImportModel> models = this.createDocuments(result.getDocumentElement(), importerData);
                boolean changed = false;
                if (models.size() > 0 && (destination = models.get(0).getDestination()).exists()) {
                    Map<String, Object> extensionsParameters = this.readExtensionsParameters(destination);
                    for (String key : extensionsParameters.keySet()) {
                        if (this.getTransformParameter(key).equals(extensionsParameters.get(key))) continue;
                        this.putTransformParameter(key, extensionsParameters.get(key));
                        changed = true;
                    }
                }
                if (changed) {
                    this.doTransaction(importerData);
                }
            }
        }
    }

    private List<ImportModel> createDocuments(Element element, ImporterData importerData) {
        ArrayList<ImportModel> processModels = new ArrayList<ImportModel>();
        ArrayList<ImportModel> testModels = new ArrayList<ImportModel>();
        try {
            int i;
            NodeList children = element.getElementsByTagName("ProcessModel");
            HashMap<Module, ArrayList<String>> modelIds = new HashMap<Module, ArrayList<String>>();
            int length = children.getLength();
            for (i = 0; i < length; ++i) {
                BPMNImportModel importModel = this.createImportModel((Element)children.item(i), processModels);
                ArrayList<String> ids = new ArrayList<String>();
                if (importModel.getModel() == null) continue;
                Document modelDoc = importModel.getModel();
                modelDoc.getDocumentElement().appendChild(ExtensionElement.createExtensionElement(modelDoc, this.getTransformParameters()));
                List idNodes = DomUtilities.selectNodes((Node)modelDoc.getDocumentElement(), (String)"//@xmi:id");
                for (Node node : idNodes) {
                    ids.add(((Attr)node).getValue());
                }
                Module module = importerData.getHelpers().getModuleFactory().getModule(importModel.getDestination(), MDBPMNImportTransaction.createModuleId(importModel.getDestination().getName()));
                modelIds.put(module, ids);
                module.addMountPointId(importModel.rootPackageID);
            }
            if (this.isCreateTestModel(importerData)) {
                children = element.getElementsByTagName("TestModel");
                length = children.getLength();
                for (i = 0; i < length; ++i) {
                    this.createTestModel((Element)children.item(i), testModels, modelIds);
                }
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        importerData.addSource(MDBPMN_IMPORT_MODELS, processModels);
        importerData.addSource("test.model.sources", testModels);
        return processModels;
    }

    private BPMNImportModel createImportModel(Element element, ArrayList<ImportModel> processModels) throws XPathExpressionException {
        BPMNImportModel importModel = null;
        NodeList models = element.getElementsByTagName("XMITransformationModel");
        if (models != null && models.getLength() == 1) {
            Element model = (Element)models.item(0);
            String name = (String)DomUtilities.evaluate((Node)model, (String)"//XMITransformationModel/datamodel/packagedElement/@name", (QName)XPathConstants.STRING);
            importModel = new BPMNImportModel(name);
            model.setAttribute("xmi:id", MDBPMNImportTransaction.createModuleId(importModel.getDestination().getName()));
            String rootPackage = (String)DomUtilities.evaluate((Node)model, (String)"//XMITransformationModel/datamodel/packagedElement/@xmi:id", (QName)XPathConstants.STRING);
            Document modelDocument = DomUtilities.newDocument();
            Node importedNode = modelDocument.importNode(model, true);
            modelDocument.appendChild(importedNode);
            Element shareTable = modelDocument.createElement("shareTable");
            Element share = modelDocument.createElement("share");
            share.setAttribute("sharedPackage", rootPackage);
            shareTable.appendChild(share);
            modelDocument.getDocumentElement().appendChild(shareTable);
            importModel.setModel(modelDocument);
            importModel.setCreate(true);
            importModel.rootPackageID = rootPackage;
            importModel.addSharedPackage(name);
            this.printSourceDocument(modelDocument, importModel.getDestination().getName() + "source");
            processModels.add(importModel);
        }
        return importModel;
    }

    private void createTestModel(Element element, ArrayList<ImportModel> testModels, HashMap<Module, ArrayList<String>> modelIds) throws XPathExpressionException {
        NodeList models = element.getElementsByTagName("XMITransformationModel");
        if (models != null && models.getLength() == 1) {
            Element model = (Element)models.item(0);
            String name = (String)DomUtilities.evaluate((Node)model, (String)"//XMITransformationModel/datamodel/packagedElement/@name", (QName)XPathConstants.STRING);
            XmiTransformationModelHelper.replaceIdRefs(model, modelIds);
            Document testDocument = DomUtilities.newDocument();
            Node importedNode = testDocument.importNode(model, true);
            testDocument.appendChild(importedNode);
            File srcFolder = CompilerConstants.getSourceFolder();
            Element mountTable = testDocument.createElement("mountTable");
            for (Module module : modelIds.keySet()) {
                mountTable.appendChild(module.toXmi(testDocument, model.getAttribute("xmi:id"), srcFolder.getPath()));
            }
            testDocument.getDocumentElement().appendChild(mountTable);
            ImportModel importModel = new ImportModel(name);
            importModel.setModel(testDocument);
            importModel.setCreate(true);
            String filename = ImportTools.createFilename(name, ".xml");
            importModel.setDestination(new File(srcFolder, filename));
            this.printSourceDocument(testDocument, importModel.getDestination().getName());
            testModels.add(importModel);
        }
    }

    private static String createModuleId(String name) {
        return "BPMN_IMPORT_" + name + ".import.xml_" + name.hashCode();
    }

    private class BPMNImportModel
    extends ImportModel {
        private String rootPackageID;

        public BPMNImportModel(String name) {
            super(name);
        }
    }
}

