/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.builder.compiler.document.importer.java.ImporterJarfile;
import ch.e2e.builder.compiler.document.importer.java.JavaImportSource;
import ch.e2e.builder.compiler.document.importer.java.JavaResourceFile;
import ch.e2e.builder.compiler.document.importer.java.Logging;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class JavaImportTransaction
extends ScriptImportTransaction
implements Logging {
    public static final String JAVA_IMPORT_MODEL = "java.import.model";
    public static final String JAVA_IMPORT_SOURCE = "java.import.source";
    public static final String ALL_JARFILES = "all.jarfiles";
    public static final String JARFILE_FOLDER = "jarfile.folder";
    public static final String RESOURCE_FILES = "resource.files";
    public static final String RESOURCES_FOLDER = "resources.folder";

    @Override
    public void doTransaction(ImporterData importerData) {
        JavaImportSource source = (JavaImportSource)importerData.getSource(JAVA_IMPORT_SOURCE);
        source.addSharedPackages();
        Document javaDocument = source.getSourceDocument();
        this.printSourceDocument(javaDocument, importerData.getFilename());
        ImportModel importModel = new ImportModel(importerData.getFilename());
        importModel.setModel(javaDocument);
        importModel.setDataModel(source.getDataModel());
        importerData.addSource(JAVA_IMPORT_MODEL, importModel);
    }

    @Override
    public void transactionFinished(ImporterData importerData) {
        this.copyFiles(importerData);
    }

    private void copyFiles(ImporterData importerData) {
        List allJarfiles = (List)importerData.getSource(ALL_JARFILES);
        File jarfileFolder = (File)importerData.getSource(JARFILE_FOLDER);
        for (ImporterJarfile file : allJarfiles) {
            File importedJarfile = new File(jarfileFolder, file.getName());
            try {
                FileUtilities.copyFile((File)file.getOriginalFile(), (File)importedJarfile);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "copyFiles", e);
            }
        }
        ArrayList<JavaResourceFile> resourceFiles = ((JavaImportSource)importerData.getSource(JAVA_IMPORT_SOURCE)).getResourceFiles();
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        for (JavaResourceFile resource : resourceFiles) {
            File resourceFolder = new File(projectHome, resource.getTemplatesFolder());
            File resourceFile = new File(resourceFolder, resource.getFile().getName());
            try {
                FileUtilities.copyFile((File)resource.getFile(), (File)resourceFile);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "copyFiles", e);
            }
        }
    }
}

