/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImportSource;
import ch.e2e.builder.compiler.document.importer.java.ArrayTypeFinder;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.ImporterJarfile;
import ch.e2e.builder.compiler.document.importer.java.JavaClass;
import ch.e2e.builder.compiler.document.importer.java.JavaImportDataModel;
import ch.e2e.builder.compiler.document.importer.java.JavaResourceFile;
import ch.e2e.builder.compiler.document.importer.java.MapTypesFinder;
import ch.e2e.builder.compiler.uml.BridgeComponent;
import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.ModelPackage;
import ch.e2e.builder.compiler.uml.UserArtifactTemplate;
import ch.e2e.builder.compiler.uml.UserComponentTemplate;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;

public class JavaImportSource
extends ImportSource {
    private JavaImportDataModel dataModel;
    private BridgePackage templatesPackage;
    private BridgeComponent javaComponent;
    private UserComponentTemplate javaComponentTemplate;
    private UserArtifactTemplate javaComponentDeployment;
    private ArrayList<JavaResourceFile> resourceFiles = new ArrayList();
    private BridgePackage componentsPackage;
    private ImportClassLoader classLoader;
    private Helpers helpers;

    public JavaImportSource(String name, ImportClassLoader classLoader, boolean onlyUseable, ArrayTypeFinder arrayTypeFinder, MapTypesFinder mapTypesFinder, File importFolder, Helpers helpers) throws ClassNotFoundException {
        this.helpers = helpers;
        this.classLoader = classLoader;
        this.dataModel = new JavaImportDataModel(name, classLoader, arrayTypeFinder, mapTypesFinder, importFolder, helpers);
        this.readExtensions(ImportModel.getDestinationFile(name));
        this.dataModel.setNamedBasedOperationSyntax(this.isNamedBasedOperationSyntax());
        this.templatesPackage = this.getHelpers().getPackagesFactory().createPackages("Component View/Templates", this.dataModel.getImportRoot(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        this.componentsPackage = this.getHelpers().getPackagesFactory().createPackages("Component View/Components", this.dataModel.getImportRoot(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        this.createJavaComponent(name);
        this.dataModel.addClasses(onlyUseable, new ArrayList<JavaClass>(classLoader.getJavaClasses()));
    }

    public JavaImportSource(String name, ImportClassLoader classLoader, File importFolder, Helpers helpers) {
        this.helpers = helpers;
        this.dataModel = new JavaImportDataModel(name, classLoader, null, null, importFolder, helpers);
        this.templatesPackage = this.getHelpers().getPackagesFactory().createPackages("Component View/Templates", this.dataModel.getModel().getOrigin(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
    }

    public JavaImportSource(String name, ImportClassLoader classLoader, boolean onlyUseable, File importFolder, Helpers helpers) throws ClassNotFoundException {
        this(name, classLoader, onlyUseable, null, null, importFolder, helpers);
    }

    protected Helpers getHelpers() {
        return this.helpers;
    }

    public Document getSourceDocument() {
        return this.dataModel.createDocument();
    }

    public void addSharedPackages() {
        for (ModelPackage modelPackage : this.dataModel.getModel().getPackages()) {
            this.dataModel.addSharedPackage(modelPackage.getOrigin());
        }
    }

    public void addJarfiles(Iterable<? extends ImporterJarfile> allJarfiles) {
        for (ImporterJarfile importerJarfile : allJarfiles) {
            this.addJarfile(importerJarfile);
        }
    }

    protected void addJarfile(ImporterJarfile importedJarfile) {
        UserComponentTemplate archive = new UserComponentTemplate(importedJarfile.getBasename(), new Comment("", this.getHelpers()), this.getHelpers().getStereotypeFactory().getStereotype("JavaArchive"), this.getHelpers());
        this.javaComponentTemplate.addChild(archive);
        archive.setOwningPackage(this.templatesPackage);
        BridgeStereotype jarFileStereotype = this.getHelpers().getStereotypeFactory().getStereotype("JarFile");
        UserArtifactTemplate jarFile = new UserArtifactTemplate(importedJarfile.getName(), new Comment("", this.getHelpers()), jarFileStereotype, this.getHelpers());
        jarFile.setClassifier(archive);
        jarFile.setPropertyValueQuietly("boot", importedJarfile.isBoot());
        jarFile.setPropertyValueQuietly("deploy", importedJarfile.isDeploy());
        this.javaComponentDeployment.addChild(jarFile);
        this.dataModel.addElement(archive);
        this.dataModel.addElement(jarFile);
        DeploymentElement jarFileArtifact = new DeploymentElement(importedJarfile.getName(), new Comment("", this.getHelpers()), jarFileStereotype, this.getHelpers());
        jarFileArtifact.setPropertyValueQuietly("boot", importedJarfile.isBoot());
        jarFileArtifact.setPropertyValueQuietly("deploy", importedJarfile.isDeploy());
        jarFileArtifact.setPropertyValueQuietly("templatesFolder", "jarfiles");
        if (this.classLoader.getJavaClasses().size() > 0) {
            this.javaComponent.addChild(jarFileArtifact);
        }
        this.dataModel.addElement(jarFileArtifact);
    }

    public void addResourceFiles(Iterable<? extends File> resourceFiles) {
        for (File file : resourceFiles) {
            this.addResourceFile(file);
        }
    }

    public ArrayList<JavaResourceFile> getResourceFiles() {
        return this.resourceFiles;
    }

    private void createJavaComponent(String name) {
        if (this.classLoader.getJavaClasses().size() > 0) {
            this.javaComponent = new BridgeComponent(name, new Comment("", this.getHelpers()), this.getHelpers().getStereotypeFactory().getStereotype("JavaComponent"), this.getHelpers());
            this.javaComponent.setOwningPackage(this.componentsPackage);
            this.dataModel.addElement(this.javaComponent);
        }
        this.javaComponentTemplate = new UserComponentTemplate(name, new Comment("", this.getHelpers()), this.getHelpers().getStereotypeFactory().getStereotype("JavaComponent"), this.getHelpers());
        this.javaComponentTemplate.setOwningPackage(this.templatesPackage);
        this.javaComponentDeployment = new UserArtifactTemplate(name, new Comment("", this.getHelpers()), this.getHelpers().getStereotypeFactory().getStereotype("JavaComponentDeployment"), this.getHelpers());
        this.javaComponentDeployment.setClassifier(this.javaComponentTemplate);
        this.javaComponentDeployment.setOwningPackage(this.templatesPackage);
        this.dataModel.addElement(this.javaComponentTemplate);
        this.dataModel.addElement(this.javaComponentDeployment);
    }

    private void addResourceFile(File resourceFile) {
        String basename = resourceFile.getName();
        int idx = basename.lastIndexOf(".");
        if (idx > -1) {
            basename = basename.substring(0, idx);
        }
        UserComponentTemplate properties = new UserComponentTemplate(basename, new Comment("", this.getHelpers()), this.getHelpers().getStereotypeFactory().getStereotype("Properties"), this.getHelpers());
        this.javaComponentTemplate.addChild(properties);
        properties.setOwningPackage(this.templatesPackage);
        BridgeStereotype stereotype = this.getHelpers().getStereotypeFactory().getStereotype("PropertiesFile");
        UserArtifactTemplate propertiesFile = new UserArtifactTemplate(resourceFile.getName(), new Comment("", this.getHelpers()), stereotype, this.getHelpers());
        propertiesFile.setClassifier(properties);
        DeploymentElement propertiesArtifact = new DeploymentElement(resourceFile.getName(), new Comment("", this.getHelpers()), stereotype, this.getHelpers());
        propertiesArtifact.setOwningPackage(this.componentsPackage);
        propertiesArtifact.setPropertyValueQuietly("templatesFolder", "resources/java/properties");
        if (this.classLoader.getJavaClasses().size() > 0) {
            BridgeDependency dependency = new BridgeDependency(null, this.getHelpers());
            dependency.setSupplier(propertiesArtifact);
            dependency.setClient(this.javaComponent);
            dependency.setUseClientPackage(true);
            propertiesArtifact.addDependency(dependency);
        }
        this.javaComponentDeployment.addChild(propertiesFile);
        this.dataModel.addElement(properties);
        this.dataModel.addElement(propertiesFile);
        this.dataModel.addElement(propertiesArtifact);
        JavaResourceFile file = new JavaResourceFile(resourceFile, "resources/java/properties");
        this.resourceFiles.add(file);
    }

    public JavaImportDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public String getDevelopmentFilename() {
        return null;
    }

    @Override
    public ImportModel getImportModel() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }
}

