/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.ArrayTypeFinder;
import ch.e2e.builder.compiler.document.importer.java.Attribute;
import ch.e2e.builder.compiler.document.importer.java.Completable;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.JavaClass;
import ch.e2e.builder.compiler.document.importer.java.MapEntry;
import ch.e2e.builder.compiler.document.importer.java.MapTypesFinder;
import ch.e2e.builder.compiler.document.importer.java.Operation;
import ch.e2e.builder.compiler.document.importer.java.Parameter;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.document.importer.java.UserAbortedClassSearchException;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaImportDataModel
extends DataModel {
    private static final String ID_PREFIX = "JAVA_IMPORT_";
    private BridgePackage importRoot;
    private ImportClassLoader classLoader;
    private List<String> classes;
    private Map<String, MapEntry> mapEntries;
    private ArrayTypeFinder arrayTypeFinder;
    private MapTypesFinder mapTypesFinder;

    public JavaImportDataModel(String name, ImportClassLoader classLoader, ArrayTypeFinder arrayTypeFinder, MapTypesFinder mapTypesFinder, File importsFolder, Helpers helpers) {
        super(name, ID_PREFIX, helpers);
        this.importRoot = this.getHelpers().getPackagesFactory().createPackages(name, this.getModel().getOrigin(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        this.classLoader = classLoader;
        this.arrayTypeFinder = arrayTypeFinder;
        this.mapTypesFinder = mapTypesFinder;
        this.classes = new ArrayList<String>();
        this.mapEntries = new HashMap<String, MapEntry>();
        Module module = helpers.getModuleFactory().getModule(new File(importsFolder, name + ".import.xml"), this.getModelId());
        this.setModule(module);
    }

    public BridgePackage getImportRoot() {
        return this.importRoot;
    }

    public void addClasses(boolean onlyUseable, ArrayList<JavaClass> javaClasses) throws ClassNotFoundException {
        for (JavaClass javaClass : javaClasses) {
            if (!javaClass.isImportable() && onlyUseable) continue;
            this.addClass(javaClass);
        }
        for (JavaClass javaClass : javaClasses) {
            if (!javaClass.isImportable() && onlyUseable) continue;
            this.addElement(javaClass);
        }
    }

    private void addClass(JavaClass javaClass) throws ClassNotFoundException {
        String fullQualifiedName = javaClass.getFullName();
        if (!this.classes.contains(fullQualifiedName)) {
            this.classes.add(fullQualifiedName);
            this.addGenerals(javaClass);
            this.addAttributes(javaClass);
            this.addMethods(javaClass);
            this.replaceRoot(javaClass);
        }
    }

    private void replaceRoot(JavaClass javaClass) {
        String packageName = (String)javaClass.getPropertyValueQuietly("package");
        if (packageName == null) {
            javaClass.setOwningPackage(this.importRoot);
        } else {
            BridgePackage importPackage = this.getHelpers().getPackagesFactory().getPackage(this.importRoot, packageName.replace('.', '/'), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
            javaClass.setOwningPackage(importPackage);
        }
    }

    private void addClass(String classname) throws UserAbortedClassSearchException {
        if (classname != null) {
            try {
                JavaClass javaClass = this.classLoader.loadAndInitializeJavaClass(classname, false, false);
                if (javaClass != null) {
                    this.addClass(javaClass);
                }
            }
            catch (Throwable e) {
                if (this.classLoader.getAbortException() != null) {
                    throw this.classLoader.getAbortException();
                }
                e.printStackTrace();
            }
        }
    }

    private void addGenerals(JavaClass javaClass) throws ClassNotFoundException {
        for (Generalization general : javaClass.getGenerals()) {
            this.addClass((JavaClass)general.getTypeClass());
        }
    }

    private void addAttributes(JavaClass javaClass) throws ClassNotFoundException {
        for (BridgeAttribute attribute : javaClass.getAttributes()) {
            this.completeElement((Attribute)attribute);
        }
    }

    private void addMethods(JavaClass javaClass) throws ClassNotFoundException {
        for (BridgeOperation o : javaClass.getOperations()) {
            Operation operation = (Operation)o;
            ArrayList<UmlElement> parameters = operation.getParameters();
            for (UmlElement parameter : parameters) {
                this.completeElement((Parameter)parameter);
            }
        }
    }

    private void completeElement(Completable element) throws ClassNotFoundException {
        if (element.isArray() || element.isCollection() || element.isMap()) {
            this.fillArrayInformation(element);
        } else if (!TypeInfo.isBaseType(element)) {
            this.addClass(element.getNativeType());
        }
    }

    private void fillArrayInformation(Completable element) throws ClassNotFoundException {
        BridgeClass bridgeType = element.getArrayElement();
        if (bridgeType == null) {
            if (element.isCollection()) {
                this.fillCollectionInfo(element);
            } else if (element.isMap()) {
                this.fillMapInfo(element);
            } else if (!TypeInfo.isBaseType(element)) {
                this.addClass(element.getNativeType());
            }
        }
    }

    private void fillCollectionInfo(Completable element) throws UserAbortedClassSearchException {
        TypeInfo typeInfo;
        Class<?> dataType = this.getDataType(element);
        if (dataType == null && this.arrayTypeFinder != null) {
            typeInfo = TypeInfo.getDefaultTypeInfo();
            if (this.arrayTypeFinder.ignoreAll()) {
                element.setArrayElement(typeInfo.getBridgeType(), typeInfo.getNativeType());
            } else {
                dataType = this.arrayTypeFinder.findDataType(this.classLoader, element);
                if (dataType == null) {
                    if (this.arrayTypeFinder.ignore() || this.arrayTypeFinder.ignoreAll()) {
                        element.setArrayElement(typeInfo.getBridgeType(), typeInfo.getNativeType());
                    } else {
                        throw new UserAbortedClassSearchException(element.getNativeType());
                    }
                }
            }
        }
        if (dataType != null) {
            typeInfo = TypeInfo.getTypeInfo(dataType, this.classLoader);
            element.setArrayElement(typeInfo.getBridgeType(), typeInfo.getNativeType());
            if (!typeInfo.isBaseType()) {
                this.addClass(element.getNativeType());
                this.addClass(element.getNativeArrayElement());
            }
        }
    }

    private Class<?> getDataType(Completable completable) {
        Class<?> result = null;
        if (completable instanceof Attribute) {
            result = this.getDataType((Attribute)completable, (JavaClass)completable.getAttributeParent());
        } else if (completable instanceof Parameter) {
            result = this.getDataType((Parameter)completable, (Operation)completable.getAttributeParent());
        }
        return result;
    }

    private Class<?> getDataType(Attribute attribute, JavaClass javaClass) {
        Class<?> result = null;
        Class<?> javaType = javaClass.getJavaType();
        String name = attribute.getName();
        try {
            Field field = javaType.getDeclaredField(name);
            Type genericType = field.getGenericType();
            result = this.getDataType(genericType);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Class<?> getDataType(Parameter parameter, Operation operation) {
        Class<?> result = null;
        JavaClass javaClass = (JavaClass)operation.getParent();
        Class<?> javaType = javaClass.getJavaType();
        String name = operation.getName();
        ArrayList parameterTypes = new ArrayList();
        for (UmlElement p : operation.getParameters()) {
            if (((Parameter)p).isReturnValue()) continue;
            parameterTypes.add(((Parameter)p).getJavaClass());
        }
        try {
            Method method = javaType.getMethod(name, parameterTypes.toArray(new Class[parameterTypes.size()]));
            if (parameter.isReturnValue()) {
                Type genericType = method.getGenericReturnType();
                result = this.getDataType(genericType);
            } else {
                Type[] genericParameterTypes;
                int indexOfChild = operation.getIndexOfChild(parameter);
                if (indexOfChild < (genericParameterTypes = method.getGenericParameterTypes()).length) {
                    result = this.getDataType(genericParameterTypes[indexOfChild]);
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Class<?> getDataType(Type genericType) {
        Type actualTypeArgument;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Class result = null;
        if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
            result = (Class)actualTypeArgument;
        }
        return result;
    }

    private void fillMapInfo(Completable completable) throws ClassNotFoundException {
        MapEntry mapEntry = this.newMapEntry(completable);
        if (mapEntry == null && this.mapTypesFinder != null) {
            if (this.mapTypesFinder.ignoreAll()) {
                completable.setArrayElement(this.getHelpers().getElementHelper().findBaseType("Base Components/Add Ons/Java/MapEntry", null), null);
            } else {
                mapEntry = this.mapTypesFinder.findDataType(this.classLoader, completable);
                if (mapEntry == null) {
                    if (this.mapTypesFinder.ignore() || this.mapTypesFinder.ignoreAll()) {
                        completable.setArrayElement(this.getHelpers().getElementHelper().findBaseType("Base Components/Add Ons/Java/MapEntry", null), null);
                    } else {
                        throw new UserAbortedClassSearchException(completable.getNativeType());
                    }
                }
            }
        }
        if (mapEntry != null) {
            completable.setArrayElement(this.getMapEntryType(mapEntry), null);
        }
    }

    private MapEntry newMapEntry(Completable completable) {
        MapEntry mapEntry = null;
        if (completable instanceof Attribute) {
            mapEntry = this.newMapEntry((Attribute)completable, (JavaClass)completable.getAttributeParent());
        } else if (completable instanceof Parameter) {
            mapEntry = this.newMapEntry((Parameter)completable, (Operation)completable.getAttributeParent());
        }
        return mapEntry;
    }

    private MapEntry newMapEntry(Attribute attribute, JavaClass javaClass) {
        MapEntry mapEntry = null;
        Class<?> javaType = javaClass.getJavaType();
        String name = attribute.getName();
        try {
            Field field = javaType.getDeclaredField(name);
            mapEntry = this.newMapEntry(field.getGenericType());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return mapEntry;
    }

    private MapEntry newMapEntry(Parameter parameter, Operation operation) {
        MapEntry mapEntry = null;
        JavaClass javaClass = (JavaClass)operation.getParent();
        Class<?> javaType = javaClass.getJavaType();
        String name = operation.getName();
        ArrayList parameterTypes = new ArrayList();
        for (UmlElement p : operation.getParameters()) {
            if (((Parameter)p).isReturnValue()) continue;
            parameterTypes.add(((Parameter)p).getJavaClass());
        }
        try {
            Method method = javaType.getMethod(name, parameterTypes.toArray(new Class[parameterTypes.size()]));
            if (parameter.isReturnValue()) {
                mapEntry = this.newMapEntry(method.getGenericReturnType());
            } else {
                int indexOfChild = operation.getIndexOfChild(parameter);
                mapEntry = this.newMapEntry(method.getGenericParameterTypes()[indexOfChild]);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return mapEntry;
    }

    private MapEntry newMapEntry(Type genericType) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        MapEntry mapEntry = null;
        if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 2) {
            Type genericTypeKey = actualTypeArguments[0];
            Type genericTypeValue = actualTypeArguments[1];
            if (genericTypeKey instanceof Class && genericTypeValue instanceof Class) {
                mapEntry = new MapEntry((Class)genericTypeKey, (Class)genericTypeValue);
            }
        }
        return mapEntry;
    }

    private JavaClass getMapEntryType(MapEntry mapEntry) throws ClassNotFoundException {
        String entryName = mapEntry.getId();
        String entryNamePrefix = "ch.e2e.bridge.map.";
        String fullName = entryNamePrefix + entryName;
        MapEntry resultEntry = this.mapEntries.get(fullName);
        if (resultEntry == null || !mapEntry.getKey().equals(resultEntry.getKey()) || !mapEntry.getValue().equals(resultEntry.getValue())) {
            int index = 1;
            while (this.mapEntries.containsKey(fullName)) {
                entryName = entryNamePrefix + entryName + '_' + index;
            }
            JavaClass entryClass = new JavaClass(entryName, mapEntry, this.classLoader, this.getHelpers());
            this.addClass(entryClass);
            this.mapEntries.put(fullName, mapEntry);
            mapEntry.setJavaType(entryClass);
            resultEntry = mapEntry;
        }
        return resultEntry.getJavaType();
    }
}

