/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.JavaClass;
import ch.e2e.builder.compiler.document.importer.java.JavaTypeNotSupportedException;
import ch.e2e.builder.compiler.document.importer.java.Logging;
import ch.e2e.builder.compiler.document.importer.java.Operation;
import ch.e2e.builder.compiler.document.importer.java.UserAbortedClassSearchException;
import ch.e2e.builder.compiler.uml.Helpers;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaCallback
extends JavaClass {
    public JavaCallback(Class clazz, Helpers helpers) {
        super(clazz, helpers.getStereotypeFactory().getStereotype("JavaCallbackInterface"), helpers);
        this.setStereotype(helpers.getStereotypeFactory().getStereotype("E2ELibraryInterface"));
    }

    @Override
    public boolean isImportable() {
        return true;
    }

    protected void findAttributes(Class clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
    }

    protected void findOperations(Class clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        try {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                try {
                    Operation operation = new Operation(method, this.getName(), classLoader, this.getHelpers());
                    operation.setStereotype(this.getHelpers().getStereotypeFactory().getStereotype("JavaCallbackOperation"));
                    operation.setStatic(true);
                    this.addOperation(operation);
                }
                catch (JavaTypeNotSupportedException e) {
                    XSLTErrorHandler.getInstance().error((Throwable)e);
                    Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
        catch (NoClassDefFoundError e) {
            if (classLoader.getAbortException() != null) {
                throw classLoader.getAbortException();
            }
            Logging.logger.warning("Could not load one or more parameter class of a operation in class '" + this.getFullName() + "'.");
        }
        catch (Throwable e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }
}

