/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.builder.compiler.document.importer.java.ArrayTypeFinder;
import ch.e2e.builder.compiler.document.importer.java.DefaultArrayTypeFinder;

public class ArrayTypeFinderFactory {
    public static final String ARRAY_TYPE_FINDER_KEY = "ch.e2e.builder.compiler.document.importer.java.ArrayTypeFinder";
    private static ArrayTypeFinder finder;

    private ArrayTypeFinderFactory() {
    }

    public static ArrayTypeFinder getArrayTypeFinder() {
        if (finder == null) {
            ArrayTypeFinderFactory.createFinder();
        }
        return finder;
    }

    public static void setArrayTypeFinder(ArrayTypeFinder finder) {
        ArrayTypeFinderFactory.finder = finder;
    }

    private static void createFinder() {
        try {
            String classname = System.getProperty(ARRAY_TYPE_FINDER_KEY);
            Class<?> clazz = Class.forName(classname, true, ArrayTypeFinderFactory.class.getClassLoader());
            finder = (ArrayTypeFinder)clazz.newInstance();
        }
        catch (Exception e) {
            finder = new DefaultArrayTypeFinder();
        }
    }
}

