/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.compiler.document.importer.idoc.DocumentationParser;
import ch.e2e.builder.compiler.document.importer.idoc.IDocObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class IDocContainerObject
extends IDocObject {
    private static String segmentVersion;
    private static String sapVersion;
    private Element element;
    private String name;
    private String type;
    private int minOccurs;
    private int maxOccurs;
    private HashMap<String, String> attributes = new HashMap();
    private ArrayList<IDocObject> children = new ArrayList();

    public IDocContainerObject(Element element) {
        this.element = element;
        this.name = element.getAttribute("name");
        this.type = element.getAttribute("type");
        NodeList children = element.getChildNodes();
        this.readChildren(children);
        this.minOccurs = this.readIntValue("loopmin", -1);
        this.maxOccurs = this.readIntValue("loopmax", -1);
    }

    public static String getSapVersion() {
        return sapVersion;
    }

    public static String getSegmentVersion() {
        return segmentVersion;
    }

    public static void setVersion(int version) {
        segmentVersion = version == 3 ? "SAPIDoc3Segment" : "SAPIDocSegment";
        sapVersion = version == 3 ? "SAPIDoc3" : "SAPIDoc";
    }

    @Override
    public void applyFieldMeta(DocumentationParser documentationParser) {
        Iterator<IDocObject> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            IDocObject aChildren;
            IDocObject child = aChildren = iterator.next();
            child.applyFieldMeta(documentationParser);
        }
    }

    @Override
    public String getDocumentation() {
        return "Status: " + this.getStatus();
    }

    public Element getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.isOptional() ? 0 : this.minOccurs;
    }

    public boolean isOptional() {
        String status = this.getStatus();
        return status != null && status.equalsIgnoreCase("optional");
    }

    public String getStatus() {
        return this.getAttribute("STATUS");
    }

    public void add(IDocObject child) {
        this.children.add(child);
    }

    public ArrayList<IDocObject> getChildren() {
        return this.children;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name.toUpperCase());
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name.toUpperCase(), value);
    }

    public String getAttributeList() {
        StringBuilder result = new StringBuilder();
        for (String key : this.attributes.keySet()) {
            String value = this.attributes.get(key);
            result.append(key).append(" = ").append(value).append(", ");
        }
        result.setLength(result.length() - 2);
        return result.toString();
    }

    protected abstract void readChildren(NodeList var1);

    protected int readIntValue(String name, int defaultValue) {
        int result;
        String intStr = this.getAttribute(name);
        if (intStr == null) {
            result = defaultValue;
        } else {
            try {
                result = Integer.parseInt(intStr);
            }
            catch (Exception e) {
                result = defaultValue;
            }
        }
        return result;
    }
}

