/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class UmlDocumentCompilerSettings {
    private File projectFolder = new File(".");
    private Map<String, File> files = new HashMap<String, File>();

    public UmlDocumentCompilerSettings(File projectFolder) {
        this.projectFolder = projectFolder;
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    private void setFile(String key, File file) {
        if (!file.isAbsolute()) {
            this.files.put(key, file);
        } else {
            String relativePath = FileUtilities.getRelativePath((File)file, (File)this.projectFolder);
            File relativeFile = new File(relativePath);
            if (!relativePath.startsWith("../") && !relativeFile.isAbsolute()) {
                this.files.put(key, relativeFile);
            } else {
                this.files.put(key, file);
            }
        }
    }

    private File getFile(String key) {
        File file = this.files.get(key);
        if (file == null) {
            return new File(this.projectFolder, key);
        }
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.projectFolder, file.getPath());
    }

    public File getUmlSourceFolder() {
        return this.getFile("uml");
    }

    public void setUmlSourceFolder(File file) {
        this.setFile("uml", file);
    }

    public File getWorkFolder() {
        return this.getFile(CompilerConstants.WORK_FOLDER);
    }

    public void setWorkFolder(File file) {
        this.setFile(CompilerConstants.WORK_FOLDER, file);
    }

    public File getRepositoryFolder() {
        return this.getFile("repository");
    }

    public void setRepositoryFolder(File file) {
        this.setFile("repository", file);
    }

    public File getResourceFolder() {
        return this.getFile("resources");
    }

    public void setResourceFolder(File file) {
        this.setFile("resources", file);
    }

    public File getJarFolder() {
        return this.getFile("jarfiles");
    }

    public void setJarFolder(File file) {
        this.setFile("jarfiles", file);
    }

    public File getLibraryFolder() {
        return this.getFile("libs");
    }

    public void setLibraryFolder(File file) {
        this.setFile("libs", file);
    }

    public File getBinaryFolder() {
        return this.getFile(".$bin");
    }

    public void setBinaryFolder(File file) {
        this.setFile(".$bin", file);
    }

    public File getXSLTFolder() {
        return this.getFile("xslt/");
    }

    public void setXSLTFolder(File file) {
        this.setFile("xslt/", file);
    }
}

