/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IncludesFile {
    private String umlFileID;
    private String filename;
    private ArrayList<String> xmiElementIDs;

    public IncludesFile(UmlDocument umlDocument) {
        this.umlFileID = umlDocument.getUniqueId();
        this.filename = CompilerConstants.isInSrcPath(umlDocument.getOriginalFile()) ? FileUtilities.getRelativePath((File)umlDocument.getOriginalFile(), (File)CompilerConstants.getSourceFolder()) : umlDocument.getOriginalFile().getName();
        this.xmiElementIDs = new ArrayList();
    }

    public IncludesFile(Element fileElement) {
        this.umlFileID = fileElement.getAttribute("umlfileid");
        this.filename = fileElement.getAttribute("filename");
        this.xmiElementIDs = new ArrayList();
        NodeList xmlElements = fileElement.getElementsByTagName("xmlelement");
        int length = xmlElements.getLength();
        for (int i = 0; i < length; ++i) {
            Element xmlElement = (Element)xmlElements.item(i);
            this.addXmiElementID(xmlElement.getAttribute("id"));
        }
    }

    public void addXmiElementID(String xmiElementID) {
        if (!this.xmiElementIDs.contains(xmiElementID)) {
            this.xmiElementIDs.add(xmiElementID);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getUmlFileID() {
        return this.umlFileID;
    }

    public boolean containsElementID(String id) {
        return this.xmiElementIDs.contains(id);
    }

    public ArrayList<String> getXmiElementIDs() {
        return this.xmiElementIDs;
    }

    public void clear() {
        this.xmiElementIDs.clear();
    }
}

