/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.compiler.descriptor.DescriptorElement;
import ch.e2e.builder.compiler.descriptor.RepositoryResource;
import java.io.File;
import org.w3c.dom.Element;

public class XSLTResource
extends RepositoryResource {
    public XSLTResource(Element xmlElement, DescriptorElement parent) {
        super(xmlElement, parent);
        this.setTargetFolder("xslt/src");
        this.setTemplatesFolder("resources/templates/xslt/src");
    }

    @Override
    protected File createTemplateFile(File templatesFolder) {
        File template = new File(templatesFolder, this.getName());
        if (!template.exists()) {
            template = this.checkXSLTResources(template);
        }
        return template;
    }

    private File checkXSLTResources(File template) {
        File projectHome = this.getUmlDocument().getSettings().getProjectFolder();
        File oldXSLTFolder = new File(projectHome, "xslt");
        File oldTemplate = new File(oldXSLTFolder, this.getName());
        File templatesFolder = new File(projectHome, this.getTemplatesFolder());
        template = new File(templatesFolder, this.getName());
        if (oldTemplate.exists()) {
            template.getParentFile().mkdirs();
            oldTemplate.renameTo(template);
        }
        return template;
    }
}

