/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.LibraryDeployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.ConfigurationError;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Library
extends CompilableObject {
    private ArrayList<String> elementIds = new ArrayList();
    private boolean allBackendsDeployed;
    private ArrayList<String> deployedArtifacts;
    private String componentVersion;

    public Library(Element libraryElement, UmlDocument umlDocument) {
        super(libraryElement, umlDocument);
        this.findElementIds(libraryElement, this.elementIds);
        this.componentVersion = libraryElement.getAttribute("version");
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    @Override
    public String getErrorLogExtension() {
        return ".library.errors";
    }

    @Override
    public int getType() {
        int errorType = this.getErrorType();
        int result = errorType == 1 ? 4002 : ((errorType & 8) != 0 ? 4005 : ((errorType & 4) != 0 ? 4004 : ((errorType & 2) != 0 ? 4003 : 4001)));
        return result;
    }

    @Override
    public void clear(boolean deleteErrorLogs) {
        this.clearAllErrors(deleteErrorLogs);
        super.clear();
    }

    public ArrayList<String> getElementIds() {
        return this.elementIds;
    }

    @Override
    public String getRepositoryFileExtension() {
        return ".lrep";
    }

    @Override
    public String getDescriptorFileExpansion() {
        return ".library";
    }

    @Override
    public boolean canBuild() {
        return super.canBuild() && this.allBackendsDeployed;
    }

    public void checkLibraryBackends(Element libraryElement) {
        this.checkBackends(libraryElement);
        if (this.deployedArtifacts.size() == 0 && this.getDeployments().size() == 0) {
            this.addDeployment(new LibraryDeployment(this.getName(), (CompilableObject)this));
        }
    }

    @Override
    protected void addDeployment(Element xmlElement) {
        LibraryDeployment deployment = new LibraryDeployment(xmlElement, (CompilableObject)this);
        this.addDeployment(deployment);
    }

    private void findElementIds(Element moduleElement, ArrayList<String> elementIds) {
        NodeList children = moduleElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = moduleElement.getChildNodes().item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (child.hasAttribute("id")) {
                elementIds.add(child.getAttribute("id"));
            }
            this.findElementIds(child, elementIds);
        }
    }

    private void checkBackends(Element libraryElement) {
        this.deployedArtifacts = new ArrayList();
        try {
            NodeList xPathResult = (NodeList)DomUtilities.evaluate((Node)libraryElement, (String)"Aliases/Alias/DeployedServiceArtifact/@id", (NamespaceContext)null, (QName)XPathConstants.NODESET);
            int length = xPathResult.getLength();
            for (int i = 0; i < length; ++i) {
                Attr id = (Attr)xPathResult.item(i);
                this.deployedArtifacts.add(id.getValue());
            }
        }
        catch (XPathExpressionException xPathResult) {
            // empty catch block
        }
        this.allBackendsDeployed = this.deployedArtifacts.size() == 0 && this.getDeployments().size() == 0 || this.deployedArtifacts.size() > 0 && this.getDeployments().size() > 0;
        int length = this.deployedArtifacts.size();
        for (int i = 0; i < length && this.allBackendsDeployed; ++i) {
            for (Deployment deployment : this.getDeployments()) {
                this.allBackendsDeployed = deployment.containsId(this.deployedArtifacts.get(i));
            }
        }
        if (!this.allBackendsDeployed) {
            this.getErrorHandler().error((AbstractBuilderError)new ConfigurationError("error.library.missing.backend.deployment", new HashMap<String, String>(), this.getUmlLocation(), this.getName()));
        }
    }
}

