/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.utils;

import ch.e2e.builder.compiler.build.tasks.Logging;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.oxm.MediaType;

public final class JaxbUtils {
    public static void marshalXml(Object jaxbElement, File file) {
        try {
            Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            JaxbUtils.marshalXml(jaxbElement, new StreamResult(file));
        }
        catch (Exception e) {
            Logging.logger.fine(String.format("Marshalling failed (%s)", e));
        }
    }

    public static void marshalXml(Object jaxbElement, Result result) throws JAXBException {
        Marshaller marshaller = JaxbUtils.newContext(jaxbElement.getClass()).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(jaxbElement, result);
    }

    public static <T> T unmarshalXml(File file, Class<T> declaredType) throws JAXBException {
        return (T)JaxbUtils.newContext(declaredType).createUnmarshaller().unmarshal((Source)new StreamSource(file), declaredType).getValue();
    }

    public static void marshallJson(Object jaxbElement, File file) throws IOException, JAXBException {
        Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
        Marshaller marshaller = JaxbUtils.newContext(jaxbElement.getClass()).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("eclipselink.media-type", (Object)MediaType.APPLICATION_JSON);
        marshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        marshaller.marshal(jaxbElement, file);
    }

    public static <T> T unmarshallJson(File file, Class<T> declaredType) throws JAXBException {
        Unmarshaller unmarshaller = JaxbUtils.newContext(declaredType).createUnmarshaller();
        unmarshaller.setProperty("eclipselink.media-type", (Object)MediaType.APPLICATION_JSON);
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        return (T)unmarshaller.unmarshal((Source)new StreamSource(file), declaredType).getValue();
    }

    private static JAXBContext newContext(Class<?> classToBeBound) throws JAXBException {
        return JAXBContextFactory.createContext((Class[])new Class[]{classToBeBound}, Collections.emptyMap());
    }
}

