/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.tabfile;

import ch.e2e.builder.compiler.build.types.tabfile.SimpleElement;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import ch.e2e.dom.DomUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RichElement
extends SimpleElement {
    private List<SimpleElement> children = new ArrayList<SimpleElement>();

    public RichElement() {
    }

    public RichElement(Element tabfileElement) {
        super(tabfileElement);
    }

    protected static Element findFirstChild(Element tabfileElement, String elementName) {
        Iterator<Element> it = RichElement.getElementIteratorByXPath(tabfileElement, elementName);
        Element result = null;
        if (it.hasNext()) {
            result = it.next();
        }
        if (it.hasNext()) {
            return null;
        }
        return result;
    }

    protected static String extractText(Element tabfileElement, String elementName) {
        Element element = RichElement.findFirstChild(tabfileElement, elementName);
        return element != null ? element.getTextContent() : null;
    }

    protected void appendChild(SimpleElement child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public Element buildDom(Element parent, boolean library) {
        Element me = super.buildDom(parent, library);
        this.resetChildren();
        for (SimpleElement child : this.children) {
            child.buildDom(me, library);
        }
        return me;
    }

    private void resetChildren() {
        this.children.clear();
        this.prepareChildren();
    }

    protected Iterator<Element> getElementIterator(Element tabfileElement, String elementName) {
        return DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName(elementName));
    }

    protected static Iterator<Element> getElementIteratorByXPath(Element tabfileElement, String xpath) {
        NodeList nodes = DomUtilities.EMPTY_NODE_LIST;
        try {
            nodes = (NodeList)DomUtilities.evaluate((Node)tabfileElement, (String)xpath, (QName)XPathConstants.NODESET);
            return nodes;
        }
        finally {
            return DomUtilities.elementIterator((NodeList)nodes);
        }
    }

    protected void prepareChildren() {
    }

    protected void appendChildren(Collection<? extends SimpleElement> c) {
        for (SimpleElement simpleElement : c) {
            this.appendChild(simpleElement);
        }
    }

    protected void appendChildren(SimpleElement ... children) {
        for (SimpleElement aChild : children) {
            this.appendChild(aChild);
        }
    }

    protected TextElement createTextElementIfExist(Element tabfileElement, String elementName) {
        String text = RichElement.extractText(tabfileElement, elementName);
        return text != null ? new TextElement(elementName, text) : null;
    }

    protected <T extends SimpleElement> T createFrom(Element tabfileElement, String elementName, Class<T> cls) {
        Element childElement = RichElement.findFirstChild(tabfileElement, elementName);
        if (childElement != null) {
            try {
                Constructor<T> ctor = cls.getConstructor(Element.class);
                return (T)((SimpleElement)ctor.newInstance(childElement));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

