/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.substitutions;

import ch.e2e.builder.compiler.build.types.substitutions.Enumerator;
import ch.e2e.builder.compiler.build.types.substitutions.TemplatedFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Variable {
    private String name;
    private String friendlyId;
    private String label;
    private String defaultValue;
    private String type;
    private ArrayList<Enumerator> enumerators;
    private Map<String, TemplatedFile> dependentFiles = new LinkedHashMap<String, TemplatedFile>();
    private boolean isDefined;

    public Variable(String name, String friendlyId, String label, String defaultValue, String type, ArrayList<Enumerator> enumerators) {
        this.setName(name);
        this.friendlyId = friendlyId;
        this.setLabel(label);
        this.setDefaultValue(defaultValue);
        this.setType(type);
        this.enumerators = enumerators;
        this.setDefined(true);
    }

    public Variable(String name) {
        this.setName(name);
        this.setDefined(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFriendlyId() {
        return this.friendlyId;
    }

    public void setFriendlyId(String friendlyId) {
        this.friendlyId = friendlyId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type != null ? type : "string";
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue != null ? defaultValue : "";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean addFile(TemplatedFile file) {
        if (this.dependentFiles.containsKey(file.getTemplate())) {
            return false;
        }
        this.dependentFiles.put(file.getTemplate(), file);
        file.increaseVariableCount();
        return true;
    }

    public TemplatedFile removeFile(String templateName) {
        TemplatedFile templatedFile = this.dependentFiles.remove(templateName);
        if (templatedFile != null) {
            templatedFile.decreaseVariableCount();
        }
        return templatedFile;
    }

    public Map<String, TemplatedFile> getDependentFiles() {
        return this.dependentFiles;
    }

    public String getMergeStrategyName() {
        return "Default";
    }

    void appendForViewTo(Node parent) {
        Element element = parent.getOwnerDocument().createElement("Override");
        element.setAttribute("label", this.getLabel());
        element.setAttribute("variable", this.getName());
        parent.appendChild(element);
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setDefined(boolean defined) {
        this.isDefined = defined;
    }

    public ArrayList<Enumerator> getEnumerators() {
        return this.enumerators;
    }

    public void setEnumerators(ArrayList<Enumerator> enumerators) {
        this.enumerators = enumerators;
    }
}

