/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.substitutions;

import ch.e2e.builder.compiler.build.types.substitutions.Variable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Section {
    private String label;
    private Map<String, Variable> overrides = new LinkedHashMap<String, Variable>();

    public Section(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<String, Variable> getOverrides() {
        return this.overrides;
    }

    public void appendOverride(Variable variable) {
        this.overrides.put(variable.getName(), variable);
    }

    public void appendOverrides(Map<String, Variable> newOverrides) {
        this.overrides.putAll(newOverrides);
    }

    public void appendTo(Element parent) {
        Element element = parent.getOwnerDocument().createElement("Section");
        for (Variable variable : this.overrides.values()) {
            if (variable.getDependentFiles().isEmpty()) continue;
            variable.appendForViewTo(element);
        }
        if (element.hasChildNodes()) {
            element.setAttribute("label", this.label);
            parent.appendChild(element);
        }
    }
}

