/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.modules;

import ch.e2e.builder.compiler.build.types.modules.Compilation;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Element;

public class Module
extends RichElement {
    public static final List<String> attributeNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("version");
        }
    };
    private Compilation compilation;
    private boolean isLibrary;

    public Module(String name, String fileName, String version) {
        this.setAttribute("name", name);
        this.setAttribute("version", version);
        this.compilation = new Compilation(fileName);
    }

    public Module(Element tabfileElement) {
        super(tabfileElement);
        this.isLibrary = "library".equalsIgnoreCase(tabfileElement.getTagName());
        this.compilation = new Compilation((Element)tabfileElement.getElementsByTagName("compilation").item(0));
    }

    @Override
    public String getElementName() {
        return this.isLibrary ? "library" : "composite";
    }

    @Override
    public Element buildDom(Element parent, boolean library) {
        return super.buildDom(parent, library);
    }

    public void setLibrary(boolean library) {
        this.isLibrary = library;
    }

    @Override
    public List<String> getAttributeNames() {
        return attributeNames;
    }

    @Override
    protected void prepareChildren() {
        this.appendChild(this.compilation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return this.isLibrary == module.isLibrary && Objects.equals(this.compilation, module.compilation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.compilation, this.isLibrary);
    }
}

