/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.timer;

import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Event
extends RichElement {
    public static final String ELEMENT_NAME = "Event";
    private String id;
    private Map<String, TextElement> settings = new TreeMap<String, TextElement>();
    public static final List<String> settingNames = new ArrayList<String>(){
        {
            this.add("FirstOccurrence");
            this.add("Occurrences");
            this.add("ParallelEvents");
            this.add("QueuedEvents");
            this.add("RepeatInterval");
            this.add("RequestName");
        }
    };

    public Event(Element tabfileElement) {
        super(tabfileElement);
        this.id = tabfileElement.getAttribute("id");
        Iterator settingIterator = DomUtilities.elementIterator((NodeList)tabfileElement.getChildNodes());
        while (settingIterator.hasNext()) {
            Element settingNode = (Element)settingIterator.next();
            if (!settingNames.contains(settingNode.getTagName())) continue;
            this.settings.put(settingNode.getTagName(), new TextElement(settingNode));
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getId() {
        return this.id;
    }

    public String getRequestName() {
        return this.settings.containsKey("RequestName") ? this.settings.get("RequestName").getText() : null;
    }

    @Override
    public Element buildDom(Element parent, boolean library) {
        Element me = super.buildDom(parent, library);
        if (library) {
            me.setAttribute("id", this.id);
            me.setAttribute("awaitingDefinition", "false");
        }
        for (TextElement setting : this.settings.values()) {
            setting.buildDom(me, library);
        }
        return me;
    }

    List<String> getVariables() {
        ArrayList<String> result = new ArrayList<String>();
        for (TextElement element : this.settings.values()) {
            String text = element.getText();
            if (!text.startsWith("${") || !text.endsWith("}")) continue;
            result.add(text.substring(2, text.length() - 1));
        }
        return result;
    }
}

