/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest.service;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.addons.InputHeaderRoles;
import ch.e2e.builder.compiler.build.types.addons.rest.service.JSONComposerOptions;
import ch.e2e.builder.compiler.build.types.tabfile.Attribute;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class Service
extends RichElement {
    public static final String ELEMENT_NAME = "Service";
    public static final List<String> attributeNames = new ArrayList<String>(){
        {
            this.add("enabled");
            this.add("maxRequestBodySize");
            this.add("maxRequestHeaderSize");
            this.add("name");
        }
    };
    private InputHeaderRoles headerRoles;

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    public Service(Element tabfileElement) {
        super(tabfileElement);
        Iterator<Element> it = Service.getElementIteratorByXPath(tabfileElement, "incomingHttpHeaderRoles");
        while (it.hasNext() && this.headerRoles == null) {
            this.headerRoles = new InputHeaderRoles(it.next());
        }
    }

    protected String extractVarName(String var) {
        return var.substring(2, var.length() - 1);
    }

    public String getName() {
        return this.getAttributeValue("name");
    }

    private String getVariableName(String suffix) {
        return "addOn_Services_Service_" + this.getName() + suffix;
    }

    private String createVariable(String suffix) {
        return "${" + this.getVariableName(suffix) + "}";
    }

    @Override
    protected void prepareChildren() {
        this.appendChild(new TextElement("MaximumConnections", this.createVariable("_MaximumConnections")));
        this.appendChild(new TextElement("ResolveHostnames", this.createVariable("_ResolveHostnames")));
        this.appendChild(new TextElement("PortNumber", this.createVariable("_Port")));
        JSONComposerOptions jsonComposerOptions = new JSONComposerOptions();
        jsonComposerOptions.addAttribute(new Attribute("compact", this.createVariable("_JSONComposerOptions_compact")));
        jsonComposerOptions.addAttribute(new Attribute("keepNulls", this.createVariable("_JSONComposerOptions_keepNulls")));
        jsonComposerOptions.addAttribute(new Attribute("writeTypeDiscriminator", this.createVariable("_JSONComposerOptions_writeTypeDiscriminator")));
        this.appendChild(jsonComposerOptions);
        this.appendChild(this.headerRoles);
    }

    public void nukeVariables(SubstitutionsTabfile substitutions, String templateName) {
        String maxRqHeaderSizeVarExpansion;
        String maxRqSizeVarExpansion;
        substitutions.removeVariableFromTemplate(this.getVariableName("_MaximumConnections"), templateName);
        substitutions.removeVariableFromTemplate(this.getVariableName("_ResolveHostnames"), templateName);
        substitutions.removeVariableFromTemplate(this.getVariableName("_Port"), templateName);
        substitutions.removeVariableFromTemplate(this.getVariableName("_JSONComposerOptions_compact"), templateName);
        substitutions.removeVariableFromTemplate(this.getVariableName("_JSONComposerOptions_keepNulls"), templateName);
        substitutions.removeVariableFromTemplate(this.getVariableName("_JSONComposerOptions_writeTypeDiscriminator"), templateName);
        String enabledVarExpansion = this.getAttributeValue("enabled");
        if (enabledVarExpansion != null) {
            substitutions.removeVariableFromTemplate(this.extractVarName(enabledVarExpansion), templateName);
        }
        if ((maxRqSizeVarExpansion = this.getAttributeValue("maxRequestBodySize")) != null) {
            substitutions.removeVariableFromTemplate(this.extractVarName(maxRqSizeVarExpansion), templateName);
        }
        if ((maxRqHeaderSizeVarExpansion = this.getAttributeValue("maxRequestHeaderSize")) != null) {
            substitutions.removeVariableFromTemplate(this.extractVarName(maxRqHeaderSizeVarExpansion), templateName);
        }
    }

    @Override
    public List<String> getAttributeNames() {
        return attributeNames;
    }
}

