/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest.descriptor;

import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.MergerMissingDefinitionFatalError;
import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Port;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.builder.compiler.xml2yaml.Xml2Yaml;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescriptorTabfile
extends XmlTabfile {
    public final String DESCRIPTOR_EXTENSION = ".yaml";
    private String descriptorFileName;
    private Port port;
    private Map<String, Port> ports = new LinkedHashMap<String, Port>();

    public DescriptorTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        this.prepareDocument(library);
    }

    @Override
    public String getExtension(boolean library) {
        return library ? super.getExtension(library) : ".yaml";
    }

    @Override
    public String getFullName(boolean library) {
        if (library) {
            return "tabfiles/" + this.getName() + this.getExtension(library);
        }
        return "swagger/" + this.descriptorFileName + this.getExtension(library);
    }

    @Override
    public String getKey(boolean library) {
        return library ? this.getName() : this.getFilename();
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        if (library.booleanValue() || this.descriptorFileName != null && !"".equals(this.descriptorFileName)) {
            super.beforeSerialize(zipOut, fileName, library);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (library) {
            super.serialize(outputStream, indent, library);
        } else {
            outputStream.write(new Xml2Yaml(this.getTabfileDocument().getDocumentElement().getFirstChild()).asString().getBytes("UTF-8"));
        }
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        NodeList portElements;
        if (this.descriptorFileName == null || "".equals(this.descriptorFileName)) {
            this.descriptorFileName = table.getAttribute("descriptorFilename");
        }
        if ((portElements = table.getElementsByTagName("port")).getLength() != 1) {
            return false;
        }
        Port newPort = new Port((Element)portElements.item(0));
        if ("Configuration".equals(configurationElement.getTagName())) {
            if (this.port != null) {
                if (newPort.isAwaitingDefinition()) {
                    newPort.mergeIn(this.port);
                    this.port = newPort;
                } else if (this.port.isAwaitingDefinition() || this.port.isGenerated() && newPort.isGenerated()) {
                    this.port.mergeIn(newPort);
                }
            } else {
                this.port = newPort;
            }
        } else {
            Port oldPort = this.ports.get(table.getAttribute("filename"));
            if (oldPort != null) {
                if (newPort.isAwaitingDefinition()) {
                    newPort.mergeIn(oldPort);
                    this.ports.put(table.getAttribute("filename"), newPort);
                } else if (oldPort.isAwaitingDefinition() || oldPort.isGenerated() && newPort.isGenerated()) {
                    oldPort.mergeIn(newPort);
                }
            } else {
                this.ports.put(table.getAttribute("filename"), newPort);
            }
        }
        return true;
    }

    boolean prepareDocument(boolean library) {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        Element root = tabfile.getDocumentElement();
        root.removeAttribute("xmlns:xmi");
        if (library) {
            root.setAttribute("multiTabfileDocument", "true");
            root.setAttribute("rootElementName", this.getRootElementName());
            for (Map.Entry<String, Port> entry : this.ports.entrySet()) {
                Element descriptorRoot = tabfile.createElement(this.getRootElementName());
                descriptorRoot.setAttribute("filename", entry.getKey());
                descriptorRoot.setAttribute("name", this.getName());
                entry.getValue().buildDom(descriptorRoot, true);
                root.appendChild(descriptorRoot);
            }
            return this.ports.size() > 0;
        }
        if (this.descriptorFileName != null && !"".equals(this.descriptorFileName)) {
            if (this.port.isAwaitingDefinition()) {
                this.getErrorHandler().fatalError((BuilderFatalError)new MergerMissingDefinitionFatalError("REST port with basePath '" + this.port.getAttributeValue("basePath") + "'"));
            }
            this.port.buildDom(root, false);
            return true;
        }
        this.setTabfileDocument(null);
        return false;
    }
}

