/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest;

import ch.e2e.builder.compiler.build.types.addons.rest.StaticSegment;
import ch.e2e.builder.compiler.build.types.addons.rest.VariableSegment;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.SimpleElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class Segment
extends RichElement {
    public static final String ELEMENT_NAME = "Segment";
    private List<SimpleElement> parts = new ArrayList<SimpleElement>();

    public Segment(Element tabfileElement) {
        super(tabfileElement);
        Iterator<Element> partIterator = Segment.getElementIteratorByXPath(tabfileElement, "Static|Variable");
        while (partIterator.hasNext()) {
            this.addPart(partIterator.next());
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    public void addPart(Element tabfileElement) {
        if ("Static".equals(tabfileElement.getTagName())) {
            this.parts.add(new StaticSegment(tabfileElement));
        } else {
            this.parts.add(new VariableSegment(tabfileElement));
        }
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.parts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return this.parts.equals(segment.parts);
    }

    @Override
    public int hashCode() {
        return this.parts.hashCode();
    }
}

