/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.addons.rest.Service;
import ch.e2e.builder.compiler.build.types.addons.rest.TopLevelResource;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestTabfile
extends XmlTabfile {
    private Map<String, TopLevelResource> portDefinitions = new TreeMap<String, TopLevelResource>();
    private Map<String, Service> services = new TreeMap<String, Service>();
    private boolean library = false;

    public RequestTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    protected static Iterator<Element> getElementIteratorByXPath(Element tabfileElement, String xpath) {
        NodeList nodes = DomUtilities.EMPTY_NODE_LIST;
        try {
            nodes = (NodeList)DomUtilities.evaluate((Node)tabfileElement, (String)xpath, (QName)XPathConstants.NODESET);
            return nodes;
        }
        finally {
            return DomUtilities.elementIterator((NodeList)nodes);
        }
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        super.doMergePostProcess(substitutions, library);
        this.library = library;
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator<Element> definitionIterator = RequestTabfile.getElementIteratorByXPath(replaced, "Resource");
        while (definitionIterator.hasNext()) {
            this.addDefinition(definitionIterator.next());
        }
        Iterator serviceIterator = DomUtilities.elementIterator((NodeList)replaced.getElementsByTagName("Service"));
        while (serviceIterator.hasNext()) {
            this.addService((Element)serviceIterator.next());
        }
        return true;
    }

    private void addDefinition(Element definitionElement) {
        TopLevelResource portDefinition = new TopLevelResource(definitionElement);
        if (this.portDefinitions.containsKey(portDefinition.getPortClass()) && "urn:xUML_Controller.xUML Runtime API".equals(portDefinition.getPortClass())) {
            this.portDefinitions.get("urn:xUML_Controller.xUML Runtime API").mergeIn(portDefinition);
        } else {
            this.portDefinitions.put(portDefinition.getPortClass(), portDefinition);
        }
    }

    private void addService(Element serviceElement) {
        Service service = new Service(serviceElement);
        this.services.put(service.getServiceName(), service);
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument();
        super.beforeSerialize(zipOut, fileName, library);
    }

    void prepareDocument() {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        tabfile.getDocumentElement().removeAttribute("xmlns:xmi");
        if (this.library) {
            for (TopLevelResource port : this.portDefinitions.values()) {
                port.buildDom(tabfile.getDocumentElement(), this.library);
            }
        } else {
            for (Service service : this.services.values()) {
                service.importPorts(this.portDefinitions);
                service.buildDom(tabfile.getDocumentElement(), this.library);
            }
        }
    }
}

