/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.filesystem;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.addons.filesystem.Operation;
import ch.e2e.builder.compiler.build.types.addons.filesystem.OperationFactory;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BaseTabfile
extends XmlTabfile {
    private Map<String, Operation> operations = new LinkedHashMap<String, Operation>();
    private boolean library = false;

    public BaseTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        this.library = library;
        super.doMergePostProcess(substitutions, library);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator operationIterator = DomUtilities.elementIterator((NodeList)replaced.getChildNodes());
        while (operationIterator.hasNext()) {
            this.addOperation((Element)operationIterator.next());
        }
        return true;
    }

    private void addOperation(Element operationElement) {
        Operation operation = OperationFactory.create(operationElement);
        this.operations.put(operation.getId(), operation);
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument();
        super.beforeSerialize(zipOut, fileName, library);
    }

    void prepareDocument() {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        tabfile.getDocumentElement().removeAttribute("xmlns:xmi");
        for (Operation opeartion : this.operations.values()) {
            opeartion.buildDom(tabfile.getDocumentElement(), this.library);
        }
    }
}

