/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.XSLTError;
import ch.e2e.builder.base.error.XSLTWarning;
import ch.e2e.builder.base.tools.Utilities;
import ch.e2e.builder.compiler.build.types.Logging;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.error.ConfigurationWarning;
import ch.e2e.dom.DomUtilities;
import ch.e2e.util.StringTools;
import java.text.ParseException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathReplacer
implements Logging {
    public static Object replaceText(String text, Document parent, Element configurationElement, CompilableObject compilableObject, AbstractErrorHandler errorHandler) {
        Object result = null;
        int startIndex = text.indexOf("$REPLACE{");
        if (startIndex == -1) {
            result = text;
        } else {
            StringBuilder replaceString = new StringBuilder();
            replaceString.append(text.substring(0, startIndex));
            boolean replaceTextData = true;
            while (startIndex > -1) {
                int endIndex = XPathReplacer.findClosingBreak(text, startIndex + 9);
                String s2 = text.substring(startIndex + 9, endIndex);
                Object xPathResult = XPathReplacer.replaceXPath(s2, parent, configurationElement, compilableObject, errorHandler);
                if (xPathResult != null) {
                    if (xPathResult instanceof String) {
                        String xPathStr = (String)xPathResult;
                        xPathStr = XPathReplacer.checkFunctions(xPathStr);
                        replaceString.append(xPathStr);
                    } else if (xPathResult instanceof Element) {
                        replaceTextData = false;
                        result = xPathResult;
                    }
                }
                if ((startIndex = text.indexOf("$REPLACE{", endIndex + 1)) == -1) {
                    replaceString.append(text.substring(endIndex + 1));
                    continue;
                }
                replaceString.append(text.substring(endIndex + 1, startIndex));
            }
            if (replaceTextData) {
                result = replaceString.toString();
                result = XPathReplacer.replaceText((String)result, parent, configurationElement, compilableObject, errorHandler);
            }
        }
        return result;
    }

    public static String checkFunctions(String xPathStr) {
        StringBuffer result;
        String token;
        String value;
        String s;
        int endIndex;
        int index = xPathStr.indexOf("$SUBSTRING-BEFORE{");
        if (index != -1) {
            endIndex = XPathReplacer.findClosingBreak(xPathStr, index + 18);
            s = xPathStr.substring(index + 18, endIndex);
            index = s.indexOf("$VALUE{");
            endIndex = XPathReplacer.findClosingBreak(s, index + 7);
            value = s.substring(index + 7, endIndex);
            index = s.indexOf("$TOKEN{");
            endIndex = XPathReplacer.findClosingBreak(s, index + 7);
            token = s.substring(index + 7, endIndex);
            if ((index = value.indexOf(token)) != -1) {
                value = value.substring(0, index);
            }
            result = new StringBuffer();
            result.append(xPathStr.substring(0, index == 0 ? 0 : index - 1)).append(value);
            if (endIndex < xPathStr.length() - 1) {
                result.append(xPathStr.substring(endIndex + 1));
            }
            xPathStr = result.toString();
        }
        if ((index = xPathStr.indexOf("$SUBSTRING-AFTER{")) != -1) {
            endIndex = XPathReplacer.findClosingBreak(xPathStr, index + 17);
            s = xPathStr.substring(index + 17, endIndex);
            index = s.indexOf("$VALUE{");
            endIndex = XPathReplacer.findClosingBreak(s, index + 7);
            value = s.substring(index + 7, endIndex);
            index = s.indexOf("$TOKEN{");
            endIndex = XPathReplacer.findClosingBreak(s, index + 7);
            token = s.substring(index + 7, endIndex);
            if ((index = value.indexOf(token)) != -1) {
                value = value.substring(index + token.length());
            }
            result = new StringBuffer();
            result.append(xPathStr.substring(0, index == 0 ? 0 : index - 1)).append(value);
            if (endIndex < xPathStr.length() - 1) {
                result.append(xPathStr.substring(endIndex + 1));
            }
            xPathStr = result.toString();
        }
        return xPathStr;
    }

    public static int findClosingBreak(String s, int startIndex) {
        int index = 0;
        int length = s.length();
        int closingBrackets = 1;
        int i = startIndex;
        while (i < length && closingBrackets > 0) {
            char c = s.charAt(i);
            if (c == '}') {
                --closingBrackets;
            } else if (c == '{') {
                ++closingBrackets;
            }
            index = i++;
        }
        return index;
    }

    public static Object replaceXPath(String text, Document parent, Element configurationElement, CompilableObject compilableObject, AbstractErrorHandler errorHandler) {
        String startsWith = null;
        int index = text.indexOf("$STARTSWITH{");
        if (index != -1) {
            int endIndex = XPathReplacer.findClosingBreak(text, index + 12);
            startsWith = text.substring(index + 12, endIndex);
            text = text.substring(0, index) + text.substring(endIndex + 1);
        }
        String endsWith = null;
        index = text.indexOf("$ENDSWITH{");
        if (index != -1) {
            int endIndex = XPathReplacer.findClosingBreak(text, index + 10);
            endsWith = text.substring(index + 10, endIndex);
            text = text.substring(0, index) + text.substring(endIndex + 1);
        }
        boolean xPathFound = false;
        boolean xPathReturnsString = false;
        String command = "$XPATH{";
        index = text.indexOf(command);
        if (index == -1) {
            command = "$XPATH_STRING{";
            index = text.indexOf("$XPATH_STRING{");
            xPathReturnsString = true;
        }
        StringBuffer cleanValue = new StringBuffer();
        Object result = null;
        do {
            XSLTError error = null;
            if (index == -1) continue;
            cleanValue.append(text.substring(0, index));
            int endIndex = text.indexOf(125, index);
            if (endIndex == -1) continue;
            String remain = text.substring(endIndex + 1);
            if (remain.startsWith(":$ERROR{")) {
                int errorEnd = XPathReplacer.findClosingBreak(remain, 8);
                error = XPathReplacer.createXsltError(remain.substring(7, errorEnd + 1));
                remain = remain.substring(errorEnd + 1);
            } else if (remain.startsWith(":$WARNING{")) {
                int errorEnd = XPathReplacer.findClosingBreak(remain, 10);
                error = XPathReplacer.createXsltWarning(remain.substring(9, errorEnd + 1));
                remain = remain.substring(errorEnd + 1);
            }
            String xPathStr = text.substring(index + command.length(), endIndex);
            NodeList xPathResult = null;
            String xPathStringResult = null;
            try {
                XPath xpath = DomUtilities.newXPath();
                if (xPathReturnsString) {
                    xPathStringResult = (String)xpath.evaluate(xPathStr, configurationElement, XPathConstants.STRING);
                } else {
                    xPathResult = (NodeList)xpath.evaluate(xPathStr, configurationElement, XPathConstants.NODESET);
                }
            }
            catch (Exception e) {
                logger.finest("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            }
            if (xPathReturnsString && xPathStringResult == null || !xPathReturnsString && (xPathResult == null || xPathResult.getLength() == 0)) {
                if (error != null) {
                    if (error instanceof XSLTWarning) {
                        errorHandler.warning((BuilderWarning)((XSLTWarning)error));
                    } else {
                        errorHandler.error((AbstractBuilderError)error);
                    }
                }
            } else {
                xPathFound = true;
                if (xPathReturnsString) {
                    cleanValue.append(xPathStringResult);
                } else if (xPathResult.item(0) instanceof Attr) {
                    String xPathValue = ((Attr)xPathResult.item(0)).getValue();
                    cleanValue.append(xPathValue);
                    if (xPathResult.getLength() > 1) {
                        errorHandler.warning((BuilderWarning)new ConfigurationWarning("XPATH.not.explicit", Utilities.createParameterMap((String)(xPathStr + ";" + compilableObject.getName())), compilableObject.getUmlLocation(), compilableObject.getName()));
                    }
                } else {
                    result = parent.createDocumentFragment();
                    int length = xPathResult.getLength();
                    for (int i = 0; i < length; ++i) {
                        Node node = xPathResult.item(i);
                        ((DocumentFragment)result).appendChild(parent.importNode(node, true));
                    }
                }
            }
            text = remain;
            xPathReturnsString = false;
            command = "$XPATH{";
            index = text.indexOf(command);
            if (index != -1) continue;
            command = "$XPATH_STRING{";
            index = text.indexOf(command);
            xPathReturnsString = true;
        } while (index != -1);
        cleanValue.append(text);
        if (result == null) {
            Object object = result = xPathFound ? cleanValue.toString() : null;
            if (result != null) {
                String resultStr = result;
                if (startsWith != null && !resultStr.startsWith(startsWith)) {
                    resultStr = startsWith + result;
                }
                if (endsWith != null && !resultStr.endsWith(endsWith)) {
                    resultStr = resultStr + endsWith;
                }
                result = resultStr;
            }
        }
        return result;
    }

    private static XSLTError createXsltError(String errorString) {
        XSLTError error = null;
        try {
            String[] errorParts = StringTools.createStringArray((String)errorString);
            if (errorParts.length == 3) {
                error = new XSLTError(errorParts[0], Utilities.createParameterMap((String)errorParts[2]), errorParts[1]);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return error;
    }

    private static XSLTWarning createXsltWarning(String errorString) {
        XSLTWarning error = null;
        try {
            String[] errorParts = StringTools.createStringArray((String)errorString);
            if (errorParts.length == 3) {
                error = new XSLTWarning(errorParts[0], Utilities.createParameterMap((String)errorParts[2]), errorParts[1]);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return error;
    }

    public static void replaceXPathExpressions(Document resultDoc, Element configurationElement, CompilableObject compilableObject, AbstractErrorHandler errorHandler) {
        Element root = resultDoc.getDocumentElement();
        XPathReplacer.replaceXPathExpressions(root, configurationElement, compilableObject, errorHandler);
    }

    public static void replaceXPathExpressions(Element element, Element configurationElement, CompilableObject compilableObject, AbstractErrorHandler errorHandler) {
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String value = attribute.getValue();
            attribute.setValue((String)XPathReplacer.replaceText(value, element.getOwnerDocument(), configurationElement, compilableObject, errorHandler));
        }
        NodeList children = element.getChildNodes();
        length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node instanceof Text) {
                Text text = (Text)node;
                Object result = XPathReplacer.replaceText(text.getData(), element.getOwnerDocument(), configurationElement, compilableObject, errorHandler);
                if (result instanceof String) {
                    text.setData((String)result);
                    continue;
                }
                if (!(result instanceof Node)) continue;
                text.getParentNode().replaceChild((Node)result, text);
                continue;
            }
            if (!(node instanceof Element)) continue;
            XPathReplacer.replaceXPathExpressions((Element)node, configurationElement, compilableObject, errorHandler);
        }
    }
}

