/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.AbstractBreakpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExceptionBreakpoint
extends AbstractBreakpoint
implements Comparable<ExceptionBreakpoint> {
    private static final boolean ENABLED_DEFAULT = true;
    protected static final String ELEMENT_NAME = "Exception";
    protected static final String ATTRIBUTE_DOMAIN = "domain";
    protected static final String ATTRIBUTE_CODE = "code";
    protected static final String ATTRIBUTE_DOCUMENT_ID = "documentId";
    protected static final String ANY = "*";
    private final String domain;
    private final String code;

    public ExceptionBreakpoint(String domain, String code, String documentId, boolean enabled) {
        super(documentId, enabled);
        this.domain = domain;
        this.code = code;
    }

    public ExceptionBreakpoint(String domain, String code, String documentId) {
        this(domain, code, documentId, true);
    }

    public ExceptionBreakpoint(String documentId) {
        this(ANY, ANY, documentId);
    }

    public ExceptionBreakpoint(Element element) {
        this(element.getAttribute(ATTRIBUTE_DOMAIN), element.getAttribute(ATTRIBUTE_CODE), element.getAttribute(ATTRIBUTE_DOCUMENT_ID), element.hasAttribute("enabled") ? Boolean.valueOf(element.getAttribute("enabled")) : true);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getNameForList() {
        return this.toString();
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Element encode(Document document) {
        Element element = document.createElement(ELEMENT_NAME);
        element.setAttribute(ATTRIBUTE_DOMAIN, this.domain);
        element.setAttribute(ATTRIBUTE_CODE, this.code);
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        element.setAttribute(ATTRIBUTE_DOCUMENT_ID, this.getDocumentId());
        return element;
    }

    public String toString() {
        return "domain = \"" + this.domain + "\", " + ATTRIBUTE_CODE + " = \"" + this.code + "\"";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ExceptionBreakpoint && this.compareTo((ExceptionBreakpoint)obj) == 0;
    }

    @Override
    public int compareTo(ExceptionBreakpoint o) {
        int result = this.getDomain().compareTo(o.getDomain());
        return result == 0 ? this.getCode().compareTo(o.getCode()) : result;
    }

    public int hashCode() {
        return (this.domain + this.code).hashCode();
    }
}

