/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CompilerVersion {
    private List<Integer> versionComponents = new ArrayList<Integer>();
    private String literalVersion;

    CompilerVersion(String versionString) {
        if (versionString.contains("-")) {
            versionString = versionString.split(Pattern.quote("-"))[0];
        }
        if (versionString.isEmpty()) {
            versionString = "0";
        }
        try {
            String[] stringComponents;
            for (String component : stringComponents = versionString.split(Pattern.quote("."))) {
                this.versionComponents.add(Integer.parseInt(component, 10));
            }
        }
        catch (NumberFormatException e) {
            this.literalVersion = versionString;
        }
    }

    boolean isGreaterEqualThan(CompilerVersion that) {
        if (this.literalVersion != null) {
            return this.literalVersion.compareToIgnoreCase(that.toString()) >= 0;
        }
        int thisSize = this.versionComponents.size();
        int thatSize = that.versionComponents.size();
        int iterations = Math.min(thisSize, thatSize);
        for (int i = 0; i < iterations; ++i) {
            if (this.versionComponents.get(i) > that.versionComponents.get(i)) {
                return true;
            }
            if (this.versionComponents.get(i) >= that.versionComponents.get(i)) continue;
            return false;
        }
        return thisSize >= thatSize;
    }

    public String toString() {
        if (this.literalVersion != null) {
            return this.literalVersion;
        }
        StringBuilder result = new StringBuilder();
        int il = this.versionComponents.size();
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                result.append('.');
            }
            result.append(this.versionComponents.get(i));
        }
        return result.toString();
    }
}

