/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.event.BridgeInstanceTemplatesChangedEvent;
import ch.e2e.builder.compiler.build.instance.ChangedSettingsConverter;
import ch.e2e.builder.compiler.build.types.BatchFile;
import ch.e2e.builder.compiler.build.types.InstanceTabfile;
import ch.e2e.builder.compiler.build.types.LoggerTemplate;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.ZipUtilities;
import ch.e2e.xuml.settings.Settings;
import ch.e2e.xuml.settings.SettingsException;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import ch.e2e.xuml.substitutor.XmlPlaceholderSubstitutor;
import ch.e2e.xuml.template.TemplateProcessingException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BridgeInstance {
    public static final String SUBSTITUTIONS_FILENAME = "substitutions.xml";
    public static final int DEFAULT_CONTROL_PORT = 20000;
    private static HashMap<String, String> DEPLOY_NAMESPACES = new HashMap();
    private Deployment deployment;
    private File instanceHome;
    private BatchFile start;
    private BatchFile kill;
    private boolean stopped;
    private boolean overrideStateDB;
    private int maxNestingLevel;
    private Settings templates;
    private File logFolder;
    private LoggerTemplate loggerTemplate;

    public BridgeInstance(Deployment deployment) {
        this.deployment = deployment;
        this.stopped = true;
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        File binariesFolder = new File(projectHome, ".$bin");
        this.instanceHome = new File(binariesFolder, this.getFullQualifiedName());
        this.start = new BatchFile.Start(this.instanceHome);
        this.kill = new BatchFile.Kill(this.instanceHome);
        this.logFolder = new File(this.instanceHome, "logs");
        this.loggerTemplate = new LoggerTemplate(new File(this.instanceHome, "repository"));
        File overrideFile = new File(this.instanceHome, "settings.xml");
        if (overrideFile.exists()) {
            try {
                this.readSettings(overrideFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.overrideStateDB = true;
            }
        }
        try {
            this.maxNestingLevel = Integer.valueOf(System.getProperty("ch.e2e.builder.base.wsdl.import.max.nesting.level"));
        }
        catch (Exception e) {
            this.maxNestingLevel = 8;
        }
    }

    public boolean checkRuntimeIsExecutable() {
        File runtimeExecutable = new File(new File(System.getProperty("ch.e2e.builder.home"), CompilerConstants.BRIDGE_RUNTIME_BINARIES_FOLDER), CompilerConstants.BRIDGE_RUNTIME_EXECUTABLE);
        return runtimeExecutable.canExecute() || runtimeExecutable.setExecutable(true, false);
    }

    public boolean exists() {
        return this.instanceHome.exists();
    }

    public boolean isOverrideStateDB() {
        return this.overrideStateDB;
    }

    public void setOverrideStateDB(boolean overrideStateDB) {
        this.overrideStateDB = overrideStateDB;
    }

    public int getMaxNestingLevel() {
        return this.maxNestingLevel;
    }

    public void setMaxNestingLevel(int maxNestingLevel) {
        this.maxNestingLevel = maxNestingLevel;
    }

    public File getInstanceHome() {
        return this.instanceHome;
    }

    public String getLocation() {
        return "http://localhost:" + this.getControlPort();
    }

    public int getControlPort() {
        if (this.templates != null) {
            try {
                return Integer.parseInt(this.templates.getSetting(this.getControlPortSettingName()).getReplacedValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 20000;
    }

    private String getControlPortSettingName() {
        return ((Composite)this.deployment.getCompilableObject()).getControlPortSettingName();
    }

    public BatchFile getStartFile() {
        return this.start;
    }

    public BatchFile getKillFile() {
        return this.kill;
    }

    public String getFullQualifiedName() {
        return this.deployment.getFullQualifiedName();
    }

    public Settings getTemplates() {
        return this.templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException, ParserConfigurationException, XPathExpressionException, SAXException, TransformerException, PlaceholderSubstitutorException, TemplateProcessingException {
        File repositoryJar = this.getRepository();
        if (repositoryJar.exists()) {
            File tabfilesFolder = new File(this.instanceHome, "repository");
            try (ZipFile repository = null;){
                repository = new ZipFile(repositoryJar);
                if (!this.start.getFile().exists() || repositoryJar.lastModified() > this.start.getFile().lastModified()) {
                    InputStream adapterTemplates;
                    if (this.instanceHome.exists()) {
                        this.migrate(new File(this.instanceHome, "settings.xml"));
                        this.deleteOldInstanceFiles();
                    } else if (!this.instanceHome.mkdirs()) {
                        throw new BuildException("Exception: Unable to create directory \"" + this.instanceHome.getAbsolutePath() + "\"");
                    }
                    this.createScripts();
                    this.extractTabfiles(repository);
                    InstanceTabfile instanceTab = new InstanceTabfile(tabfilesFolder);
                    instanceTab.write();
                    this.createTemplates(repository);
                    this.loggerTemplate.write();
                    this.createDeployFile(repository);
                    InputStream asyncTraceIn = repository.getInputStream(new ZipEntry("asynchronous.trace"));
                    if (asyncTraceIn != null) {
                        FileUtilities.copy((InputStream)asyncTraceIn, (OutputStream)new FileOutputStream(new File(this.instanceHome, "asynchronous.trace")));
                    }
                    if ((adapterTemplates = repository.getInputStream(new ZipEntry("adapter.templates.zip"))) != null) {
                        FileUtilities.copy((InputStream)adapterTemplates, (OutputStream)new FileOutputStream(new File(this.instanceHome, "adapter.templates.zip")));
                    }
                    if (!this.logFolder.exists() && !this.logFolder.mkdirs()) {
                        throw new BuildException("Exception: Unable to create directory \"" + this.logFolder.getAbsolutePath() + "\"");
                    }
                    File logFolderError = new File(this.logFolder, "error");
                    if (!logFolderError.exists() && !logFolderError.mkdirs()) {
                        throw new BuildException("Exception: Unable to create directory \"" + logFolderError.getAbsolutePath() + "\"");
                    }
                    File tmpDir = new File(this.instanceHome, "tmp");
                    if (!tmpDir.exists() && !tmpDir.mkdirs()) {
                        throw new BuildException("Exception: Unable to create directory \"" + tmpDir.getAbsolutePath() + "\"");
                    }
                    this.deployment.setStatus(5);
                } else {
                    this.readTemplatesFromFile(repository);
                }
            }
        }
    }

    private void createDeployFile(ZipFile repository) throws IOException, PlaceholderSubstitutorException {
        InputStreamReader in = new InputStreamReader(repository.getInputStream(new ZipEntry("deploy.xml")));
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(this.instanceHome, "deploy.xml")));
        new XmlPlaceholderSubstitutor(true).applySubstitutions((Reader)in, (Writer)out, this.templates.getSubstitutions("deploy.xml"));
    }

    public File getRepository() {
        File jarfileFolder = new File(System.getProperty("ch.e2e.builder.base.repository"), this.deployment.getUmlDocument().getDocumentName());
        return new File(jarfileFolder, this.deployment.getName() + this.deployment.getCompilableObject().getRepositoryFileExtension());
    }

    public InputStream getDescriptorFile() throws IOException {
        File repositoryJar = this.getRepository();
        ZipFile repository = new ZipFile(repositoryJar);
        return repository.getInputStream(new ZipEntry("deploy.xml"));
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public LoggerTemplate getLoggerTemplate() {
        return this.loggerTemplate;
    }

    public void writeTemplates() throws TransformerException, IOException, ParserConfigurationException, SAXException {
        this.writeTemplateParameters(new File(this.instanceHome, "builder.xml"));
        try {
            this.templates.storeChangedSettings(this.templates.getModifiedSettings());
        }
        catch (SettingsException e) {
            throw new IOException(e);
        }
        this.writeTabFiles();
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    private void writeTabFiles() throws IOException {
        try {
            Properties bridgeProperties = new Properties();
            bridgeProperties.setProperty("server_hostname", "localhost");
            bridgeProperties.setProperty("CONSOLE_HOME", new File(System.getProperty("ch.e2e.builder.home"), "bin").getAbsolutePath());
            this.templates.createTabFilesFromTemplate(bridgeProperties);
        }
        catch (SettingsException e) {
            throw new IOException(e);
        }
    }

    private void writeTemplateParameters(File overrideFile) throws IOException, TransformerException {
        Document document = DomUtilities.newDocument((String)"Settings");
        Element overrideStateDB = document.createElement("OverrideStateDB");
        overrideStateDB.setAttribute("value", String.valueOf(this.overrideStateDB));
        document.getDocumentElement().appendChild(overrideStateDB);
        Element maxNestingLevel = document.createElement("MaxNestingLevel");
        maxNestingLevel.setAttribute("value", String.valueOf(this.maxNestingLevel));
        document.getDocumentElement().appendChild(maxNestingLevel);
        DomUtilities.serialize((File)overrideFile, (Document)document, (boolean)true);
    }

    private void deleteOldInstanceFiles() {
        File[] files;
        File builderConfiguration = new File(this.instanceHome, "builder.xml");
        File changedSettings = new File(this.instanceHome, "changedSettings.xml");
        File traceDB = new File(this.instanceHome, "trace.db");
        File pstateDB = new File(this.instanceHome, "pstate.db");
        File pstateTab = new File(this.instanceHome, "PersistentState.tab");
        for (File file : files = FileUtilities.getAllFiles((File)this.instanceHome, (boolean)true)) {
            if (file.equals(builderConfiguration) || file.equals(traceDB) || file.equals(changedSettings) || file.getAbsolutePath().contains("java" + File.separator + "lib") && file.getName().endsWith("properties") || file.equals(pstateDB) && !this.overrideStateDB || file.equals(pstateTab) && !this.overrideStateDB || !file.exists() || file.delete()) continue;
            throw new BuildException("Exception: Unable to delete \"" + file.getAbsolutePath() + "\"");
        }
    }

    private void createScripts() throws FileNotFoundException {
        File binaries = new File(this.instanceHome, "bin");
        if (!binaries.mkdirs()) {
            // empty if block
        }
        this.start.print();
        this.kill.print();
    }

    private void extractTabfiles(ZipFile repository) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        File tabfiles = new File(this.instanceHome, "repository");
        Document deploy = ZipUtilities.getZippedDocumentFromFile((ZipFile)repository, (String)"deploy.xml", (boolean)false, (boolean)false, (boolean)false);
        List repositoryEntries = DomUtilities.selectNodes((Node)deploy, (String)"/deploy:DeploymentDescriptor/deploy:RepositoryConfiguration/deploy:RepositoryEntries/deploy:RepositoryEntry", DEPLOY_NAMESPACES);
        if (repositoryEntries != null) {
            for (Node node : repositoryEntries) {
                if (!((Element)node).hasAttribute("path")) continue;
                String path = ((Element)node).getAttribute("path");
                ZipUtilities.extract((ZipFile)repository, (String)path, (boolean)true, (File)tabfiles);
            }
        }
    }

    private void createTemplates(ZipFile repository) throws IOException, ParserConfigurationException, SAXException, TransformerException, XPathExpressionException {
        this.readTemplatesFromFile(repository);
        this.writeTabFiles();
        EventController.fire((EventObject)new BridgeInstanceTemplatesChangedEvent(this, this));
    }

    private void readTemplatesFromFile(ZipFile repository) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        try {
            ZipEntry entry = repository.getEntry(SUBSTITUTIONS_FILENAME);
            if (entry == null) {
                throw new IOException("File substitutions.xml is missing in " + this.getRepository() + ".");
            }
            File changedSettingsFile = new File(this.instanceHome, "changedSettings.xml");
            InputStream changedSettings = changedSettingsFile.exists() ? new FileInputStream(changedSettingsFile) : new ByteArrayInputStream("<overrides/>".getBytes());
            this.templates = new Settings(this.instanceHome, this.getRepository(), repository.getInputStream(entry), changedSettings);
            this.templates.storeChangedSettings(this.templates.getModifiedSettings());
        }
        catch (SettingsException e) {
            throw new IOException(e);
        }
    }

    private Document readSettings(File overrideFile) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Document override = DomUtilities.parse((File)overrideFile, (boolean)false, (boolean)false, (boolean)false);
        Element overrideStateDB = (Element)DomUtilities.evaluate((Node)override.getDocumentElement(), (String)"OverrideStateDB", (QName)XPathConstants.NODE);
        this.overrideStateDB = DomUtilities.getBoolean((Element)overrideStateDB, (String)"value", (boolean)true);
        Element maxNestingLevel = (Element)DomUtilities.evaluate((Node)override.getDocumentElement(), (String)"MaxNestingLevel", (QName)XPathConstants.NODE);
        if (maxNestingLevel != null) {
            this.maxNestingLevel = DomUtilities.getInt((Element)maxNestingLevel, (String)"value", (int)8);
        }
        return override;
    }

    private void migrate(File oldSettings) throws BuildException {
        if (oldSettings.exists()) {
            try {
                this.readSettings(oldSettings);
                this.writeTemplateParameters(new File(this.instanceHome, "builder.xml"));
                Document changedSettingsDoc = new ChangedSettingsConverter().convert(oldSettings);
                FileOutputStream target = new FileOutputStream(new File(this.instanceHome, "changedSettings.xml"));
                DomUtilities.serialize((OutputStream)target, (Document)changedSettingsDoc, (boolean)true, (boolean)true);
            }
            catch (Exception e) {
                throw new BuildException(e);
            }
        }
    }

    static {
        DEPLOY_NAMESPACES.put("deploy", "http://e2e.ch/bridge");
    }
}

