/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libs;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.build.tasks.uml.UmlHelper;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.library.Library;
import ch.e2e.builder.compiler.uml.BridgeComponent;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.dom.DeferredElementNSImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LibraryComponentsTask
extends CacheAbleTask
implements XSLTTransformSource {
    private Document result;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._library_components_xml);
    }

    public LibraryComponentsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library_components_xml;
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        return result;
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> sourceSet = new HashSet<String>();
        sourceSet.add(this.getSourceId());
        sourceSet.add(this.getDestinationFilePathWithoutExtension() + Extensions._import_component_xmiTransformationModel_xml);
        return sourceSet;
    }

    protected String getSourceId() {
        return this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().get(this.getDestinationFileNameWithoutExtension());
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            IDLSource idlSource = (IDLSource)this.getSource(this.getSourceId());
            IDLImportSource idlImportSource = idlSource.getIDLImportSource();
            Document document = DomUtilities.newDocument((String)"http://scheer-group.com/xuml", (String)"xuml:components");
            Element components = document.getDocumentElement();
            Element module = document.createElementNS("http://scheer-group.com/xuml", "xuml:module");
            components.appendChild(module);
            module.appendChild(idlImportSource.getDataModel().getModule().toXmi(document, idlImportSource.getDataModel().getModelId(), UmlHelper.getWorkUmlFolder(this.getSourceManager().getWorkFolder()).getPath()));
            Element library = document.createElementNS("http://scheer-group.com/xuml", "xuml:library");
            components.appendChild(library);
            if (idlImportSource instanceof Library) {
                Element libraryProxy = document.createElementNS("http://scheer-group.com/xuml", "xuml:libraryProxy");
                library.appendChild(libraryProxy);
                BridgeComponent libraryProxyComponent = ((Library)idlImportSource).getLibraryProxy();
                libraryProxy.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getDestinationFileNameWithoutExtension() + Extensions._import_xml + "#" + libraryProxyComponent.getXmiID());
                this.addJavaPorts(document, components);
            }
            DomUtilities.serialize((File)this.getDestinationFile(), (Document)document, (boolean)true);
            this.result = document;
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    private void addJavaPorts(Document document, Element components) throws Exception {
        File importModelFile = ((CacheAbleTask)this.getSource(this.getDestinationFilePathWithoutExtension() + Extensions._import_component_xmiTransformationModel_xml)).getDestinationFile();
        Element importModel = DomUtilities.parse((File)importModelFile, (boolean)false, (boolean)false, (boolean)true).getDocumentElement();
        HashMap<String, String> namespaces = new HashMap<String, String>(){
            {
                this.put("ebp", "http://e2e.ch/bridge/profile");
            }
        };
        List javaPorts = DomUtilities.selectNodes((Node)importModel, (String)"//ebp:E2EJavaPort", (Map)namespaces);
        for (Node port : javaPorts) {
            Element javaPortClass = document.createElementNS("http://scheer-group.com/xuml", "xuml:javaPort");
            components.appendChild(javaPortClass);
            String baseClass = ((DeferredElementNSImpl)port).getAttribute("base_Class");
            javaPortClass.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getDestinationFileNameWithoutExtension() + Extensions._import_xml + "#" + baseClass);
        }
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

