/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.handler.Selector;
import ch.e2e.builder.compiler.build.tasks.source.FileSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.Logging;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.document.JsonDocument;
import ch.e2e.builder.compiler.document.json.DeploymentInfo;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnDefinitions;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import ch.e2e.builder.compiler.document.json.library.LibraryForm;
import ch.e2e.builder.compiler.document.json.xuml.XumlActionScript;
import ch.e2e.builder.compiler.document.json.xuml.XumlActivity;
import ch.e2e.builder.compiler.document.json.xuml.XumlArtifact;
import ch.e2e.builder.compiler.document.json.xuml.XumlClass;
import ch.e2e.builder.compiler.document.json.xuml.XumlCompilerConfig;
import ch.e2e.builder.compiler.document.json.xuml.XumlExecution;
import ch.e2e.builder.compiler.document.json.xuml.XumlInterface;
import ch.e2e.builder.compiler.document.json.xuml.XumlJavaScript;
import ch.e2e.builder.compiler.document.json.xuml.XumlLibraryUsage;
import ch.e2e.builder.compiler.document.json.xuml.XumlMapping;
import ch.e2e.builder.compiler.document.json.xuml.XumlPackage;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.document.json.xuml.component.XumlComponents;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class Json2XmlTask
extends CacheAbleTask
implements JsonDocumentSource,
XSLTTransformSource {
    private Class<? extends JsonDocument> type;
    private JsonDocument jsonDocument;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._xml);
    }

    public Json2XmlTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    public Json2XmlTask(SourceManager sourceManager, String id, Class<? extends JsonDocument> type) {
        this(sourceManager, id);
        this.type = type;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._xml;
    }

    private String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + Extensions._json;
    }

    private Class<? extends JsonDocument> getType() {
        if (this.type != null) {
            return this.type;
        }
        String id = this.getDestinationFilePathWithoutExtension();
        if (id.equals(Files.project)) {
            return XumlProject.class;
        }
        if (id.equals(Files.deployment)) {
            return DeploymentInfo.class;
        }
        if (id.endsWith(Extensions._activity)) {
            return XumlActivity.class;
        }
        if (id.endsWith(Extensions._library)) {
            return XumlLibraryUsage.class;
        }
        if (id.endsWith(Extensions._bpmn)) {
            return BpmnDefinitions.class;
        }
        if (id.endsWith(Extensions._execution)) {
            return XumlExecution.class;
        }
        if (id.endsWith(Extensions._mapping)) {
            return XumlMapping.class;
        }
        if (id.endsWith(Extensions._actionScript)) {
            return XumlActionScript.class;
        }
        if (id.endsWith(Extensions._javaScript)) {
            return XumlJavaScript.class;
        }
        if (id.endsWith(Extensions._class)) {
            return XumlClass.class;
        }
        if (id.endsWith(Extensions._interface)) {
            return XumlInterface.class;
        }
        if (id.endsWith(Extensions._package)) {
            return XumlPackage.class;
        }
        if (id.endsWith(Extensions._library_form)) {
            return LibraryForm.class;
        }
        if (id.endsWith(Extensions._form)) {
            return XumlForm.class;
        }
        if (id.endsWith(Extensions._descriptor)) {
            return LibraryDescriptor.class;
        }
        if (id.endsWith(Extensions._artifact)) {
            return XumlArtifact.class;
        }
        if (id.equals(Files.compiler + Extensions._config)) {
            return XumlCompilerConfig.class;
        }
        if (id.endsWith(Extensions._components)) {
            return XumlComponents.class;
        }
        return null;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        Class<? extends JsonDocument> type = this.getType();
        FileSource source = (FileSource)this.getSource(this.getSourceId());
        if (source == null) {
            return;
        }
        try {
            this.jsonDocument = JaxbUtils.unmarshallJson(source.getFile(), type);
            if (!this.getErrorHandler().hasErrors()) {
                this.transform(this.jsonDocument);
            }
            if (!this.getErrorHandler().hasErrors()) {
                DOMResult result = new DOMResult();
                JaxbUtils.marshalXml((Object)this.jsonDocument, result);
                DomUtilities.serialize((File)this.getDestinationFile(), (Node)result.getNode(), (boolean)true);
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    protected void transform(JsonDocument jsonDocument) {
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T extends JsonDocument> T getJsonDocument(Class<T> type) {
        if (this.jsonDocument == null) {
            if (!this.isExecuted()) {
                this.execute();
            }
            if (this.isUpToDate()) {
                try {
                    this.jsonDocument = (JsonDocument)JaxbUtils.unmarshalXml(this.getDestinationFile(), type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (T)this.jsonDocument;
    }

    public static class Factory
    extends TaskFactory {
        private Class<? extends JsonDocument> type;

        public Factory(Class<? extends JsonDocument> type, Double priority) {
            super(priority);
            this.type = type;
        }

        protected Selector getSelector(Class<? extends JsonDocument> type) {
            return id -> {
                try {
                    Method select = type.getMethod("select", String.class);
                    if (!Modifier.isStatic(select.getModifiers())) {
                        Logging.logger.warning("'select' method is not static on class " + type.getCanonicalName());
                        return false;
                    }
                    if (Boolean.class.isAssignableFrom(select.getReturnType())) {
                        return (Boolean)select.invoke(null, id);
                    }
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                return false;
            };
        }

        @Override
        public Boolean matchId(String id) {
            return Json2XmlTask.select(id) != false && this.getSelector(this.type).select(id) != false;
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new Json2XmlTask(sourceManager, id, this.type);
        }
    }
}

