/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.UnzipTask;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import com.scheer.pas.compiler.xuml.api.tasks.libraries.LibraryItemTypeService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;

public class UnzipLibraryTask
extends UnzipTask {
    private final LibraryItemTypeService libraryItemTypeService;

    public UnzipLibraryTask(SourceManager sourceManager, String id, LibraryItemTypeService libraryItemTypeService) {
        super(sourceManager, id);
        this.libraryItemTypeService = libraryItemTypeService;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getSourceId());
        this.libraryItemTypeService.getItemTypes().forEach(itemType -> set.addAll(itemType.getUnzipSourceSet(this.getSourceManager())));
        return set;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library + Extensions._zip_file_list;
    }

    @Override
    protected String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + Extensions._library_xlib;
    }

    @Override
    protected List<String> getEntryTargetPath(ZipEntry zipEntry) {
        ArrayList<String> paths = new ArrayList<String>(super.getEntryTargetPath(zipEntry));
        this.libraryItemTypeService.getItemTypes().forEach(itemType -> paths.addAll(itemType.getUnzipTargetPaths(zipEntry, this.sourceManager)));
        if (zipEntry.getName().endsWith(Extensions._lrep)) {
            paths.add(Files.libs__LIBRARY_lrep(this.getDestinationFileNameWithoutExtension()));
        }
        return paths;
    }

    public static class Factory
    extends TaskFactory {
        LibraryItemTypeService libraryItemTypeService;

        public Factory(LibraryItemTypeService libraryItemTypeService, Double priority) {
            super(priority);
            this.libraryItemTypeService = libraryItemTypeService;
        }

        @Override
        public Boolean matchId(String id) {
            return id.endsWith(Extensions._library + Extensions._zip_file_list);
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new UnzipLibraryTask(sourceManager, id, this.libraryItemTypeService);
        }
    }
}

