/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibrariesHelper;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMap;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.Set;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;

public class LibraryIdlMapTask
extends CacheAbleTask
implements LibraryIdlMapSource {
    public static String LibraryIdlMapTask_ID = Folders.libs_ + "libraryIdlMap.xml";
    LibraryIdlMap libraryIdlMap = null;

    public static Boolean select(String id) {
        return id.equals(LibraryIdlMapTask_ID);
    }

    public LibraryIdlMapTask(SourceManager sourceManager, String id) {
        super(sourceManager, LibraryIdlMapTask_ID);
    }

    protected Set<String> getDescriptorsSourceSet() {
        return LibrariesHelper.getDescriptorsSourceSet(this.getSourceManager());
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        result.addAll(this.getDescriptorsSourceSet());
        return result;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.libraryIdlMap = new LibraryIdlMap();
            this.getDescriptorsSourceSet().forEach(s -> {
                JsonDocumentSource source = (JsonDocumentSource)this.getSource((String)s);
                LibraryDescriptor descriptor = source.getJsonDocument(LibraryDescriptor.class);
                if (descriptor.getContent().getImplementation() != null) {
                    String ext = null;
                    switch (descriptor.getContent().getImplementation()) {
                        case xml: {
                            ext = Extensions._library_idl_xml;
                            break;
                        }
                        case json: {
                            ext = Extensions._library_idl_json;
                            break;
                        }
                        case lrep: {
                            ext = Extensions._library_lrep_idl_xml;
                        }
                    }
                    this.libraryIdlMap.map.put(descriptor.getName(), Folders.libs_ + descriptor.getName() + Folders.SEPARATOR + descriptor.getName() + ext);
                }
            });
            DOMResult result = new DOMResult();
            JaxbUtils.marshalXml((Object)this.libraryIdlMap, result);
            DomUtilities.serialize((File)this.getDestinationFile(), (Node)result.getNode(), (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public LibraryIdlMap getLibraryIdlMap() {
        if (this.libraryIdlMap == null) {
            if (!this.isExecuted()) {
                this.execute();
            }
            if (this.isUpToDate()) {
                try {
                    this.libraryIdlMap = JaxbUtils.unmarshalXml(this.getDestinationFile(), LibraryIdlMap.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.libraryIdlMap;
    }
}

