/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.control;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.tasks.control.TraceCompileControl;
import ch.e2e.builder.compiler.utils.EnvUtils;
import java.nio.file.Path;

public class CompileControlFactory {
    private static final String COMPILE_CONTROL_TRACE_ENABLED = "compile-control_trace_enabled";

    public static boolean tracingEnabled() {
        return EnvUtils.get(COMPILE_CONTROL_TRACE_ENABLED, Boolean.getBoolean("ch.e2e.builder.development"));
    }

    public CompileControl buildTraceCompileControl(Path workFolder, int compilationNumber) {
        if (!CompileControlFactory.tracingEnabled()) {
            return null;
        }
        return new TraceCompileControl(workFolder.resolve(Files.compile + "." + compilationNumber + Extensions._log_txt));
    }
}

