/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.AfterXSLTTask;
import ch.e2e.builder.compiler.build.tasks.JavaScriptCompiler;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Xmi2TabAfterTask
extends AfterXSLTTask {
    private Document sourceDocument;
    private File dest;

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        if (this.getUmlDocument() != null) {
            this.getErrorHandler().addTo((AbstractErrorHandler)this.getUmlDocument().getErrorHandler());
            this.getUmlDocument().getErrorHandler().serialize(false);
        }
    }

    public Document getSourceDocument() throws IOException, SAXException, ParserConfigurationException {
        return this.sourceDocument;
    }

    private File getTargetFile(UmlDocument umlDocument) {
        return new File(umlDocument.getDocumentWorkingFolder(), umlDocument.getUniqueId() + ".tabfiles");
    }

    public void setSourceDocument(Document sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    @Override
    public void executeTask(int dependencyLevel) throws BuildException {
        UmlDocument umlDocument = this.getUmlDocument();
        if (umlDocument == null) {
            throw new BuildException("UmlDocument not defined for task: " + this.getClass().getSimpleName());
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("document.name", umlDocument.getDocumentName());
        parameters.put("absolute path", umlDocument.getAbsolutePath());
        SendStatusEvent event = new SendStatusEvent((Object)this, "status.compiling", parameters);
        EventController.fire((EventObject)event);
        try {
            Document xmlDocument = this.getSourceDocument();
            if (xmlDocument == null) {
                throw new BuildException("Unable to find source for compiler task: " + this.getClass().getSimpleName());
            }
            this.optimizeJavaScript();
            Element tables = xmlDocument.getDocumentElement();
            tables.setAttribute("trace", String.valueOf(XSLTInput.getTraceState()));
            tables.setAttribute("statemachineManual", String.valueOf(XSLTInput.statemachineManual));
            File workingFolder = this.getUmlDocument().getDocumentWorkingFolder();
            this.extractJavaClasses(tables.getElementsByTagName("JavaClasses"), workingFolder);
            this.extractAsynchronousTrace(tables);
            this.extractLibraryInterface(tables);
            File targetFile = this.getTargetFile(umlDocument);
            DomUtilities.serialize((File)targetFile, (Document)xmlDocument, (boolean)false);
            if (this.getDest() != null) {
                DomUtilities.serialize((File)this.getDest(), (Document)xmlDocument, (boolean)true);
            }
        }
        catch (Exception e) {
            this.showFatalError(e.getMessage());
            this.getErrorHandler().error((Throwable)e);
            Logging.logger.throwing(this.getClass().getName(), "executeTask", e);
        }
    }

    private void optimizeJavaScript() {
        if (Boolean.valueOf(CompilerConstants.getProjectValue("optimize.java.script")).booleanValue()) {
            File[] jsFiles;
            File uiPath = new File(XSLTInput.getUIPath());
            for (File jsFile : jsFiles = FileUtilities.getFileList((File)uiPath, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getAbsolutePath().endsWith(".js");
                }
            })) {
                JavaScriptCompiler compiler = new JavaScriptCompiler(jsFile);
                compiler.compile();
                compiler.getErrorHandler().addTo(this.getErrorHandler());
            }
        }
    }

    private void extractJavaClasses(NodeList classesList, File workingFolder) throws FileNotFoundException, XPathExpressionException {
        File wrapperSrcFolder = new File(workingFolder, "wrapper/src");
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        int length = classesList.getLength();
        for (int i = 0; i < length; ++i) {
            NodeList classes = ((Element)classesList.item(i)).getElementsByTagName("Class");
            int classesLength = classes.getLength();
            for (int j = 0; j < classesLength; ++j) {
                this.createJavaClass((Element)classes.item(j), wrapperSrcFolder);
            }
            nodesToRemove.add(classesList.item(i));
        }
        for (Node node : nodesToRemove) {
            node.getParentNode().removeChild(node);
        }
    }

    private void createJavaClass(Element classElement, File wrapperSrcFolder) throws FileNotFoundException, XPathExpressionException {
        String packageName = classElement.getAttribute("package");
        String name = classElement.getAttribute("name");
        File srcFile = new File(wrapperSrcFolder, packageName.replace('.', '/') + '/' + name + ".java");
        srcFile.getParentFile().mkdirs();
        PrintWriter javaOut = new PrintWriter(srcFile);
        this.printHeader(classElement, packageName, javaOut);
        String superClass = classElement.getAttribute("extends");
        String extendsStr = superClass.length() == 0 ? "" : " extends " + superClass;
        String implementsStr = this.createImplementsString(classElement.getElementsByTagName("Implements"));
        if (DomUtilities.getBoolean((Element)classElement, (String)"isAbstract", (boolean)false)) {
            javaOut.print("abstract ");
        }
        javaOut.print("public class " + name + extendsStr + implementsStr + " {\n");
        this.printAttributes((NodeList)DomUtilities.evaluate((Node)classElement, (String)"Attribute[@visibility='public']", (NamespaceContext)null, (QName)XPathConstants.NODESET), javaOut);
        this.printAttributes((NodeList)DomUtilities.evaluate((Node)classElement, (String)"Attribute[@visibility='private']", (NamespaceContext)null, (QName)XPathConstants.NODESET), javaOut);
        this.printConstructors((NodeList)DomUtilities.evaluate((Node)classElement, (String)"Constructor", (NamespaceContext)null, (QName)XPathConstants.NODESET), name, javaOut);
        this.printMethods((NodeList)DomUtilities.evaluate((Node)classElement, (String)"Method", (NamespaceContext)null, (QName)XPathConstants.NODESET), javaOut);
        javaOut.print("}");
        javaOut.flush();
        javaOut.close();
    }

    private void printHeader(Element classElement, String packageName, PrintWriter javaOut) {
        javaOut.print("/*\n * Scheer PAS\n * Copyright 2001-2013 Scheer PAS. All rights reserved.\n * Generated. Do not touch.\n */\n");
        javaOut.print("package " + packageName + ";\n\n");
        NodeList imports = classElement.getElementsByTagName("Import");
        int length = imports.getLength();
        TreeSet<String> importedClasses = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (int i = 0; i < length; ++i) {
            String classToImport;
            Element importElement = (Element)imports.item(i);
            if (importElement.getFirstChild() == null || importedClasses.contains(classToImport = importElement.getFirstChild().getNodeValue())) continue;
            importedClasses.add(classToImport);
        }
        for (String classToImport : importedClasses) {
            if (classToImport.indexOf(46) != -1 && classToImport.substring(0, classToImport.lastIndexOf(46)).equals("java.lang")) continue;
            javaOut.print("import " + classToImport + ";\n");
        }
        javaOut.print('\n');
    }

    private String createImplementsString(NodeList elementsByTagName) {
        StringBuilder result = new StringBuilder();
        int length = elementsByTagName.getLength();
        for (int i = 0; i < length; ++i) {
            Element interfaceElement = (Element)elementsByTagName.item(i);
            if (result.length() == 0) {
                result.append(" implements ").append(interfaceElement.getAttribute("name"));
                continue;
            }
            result.append(", ").append(interfaceElement.getAttribute("name"));
        }
        return result.toString();
    }

    private void printAttributes(NodeList attributes, PrintWriter javaOut) {
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Element attribute = (Element)attributes.item(i);
            javaOut.print('\t' + attribute.getAttribute("visibility") + ' ' + attribute.getAttribute("type") + ' ' + attribute.getAttribute("name"));
            if (attribute.hasAttribute("default") && attribute.getAttribute("default").length() > 0) {
                javaOut.print(" = " + attribute.getAttribute("default"));
            }
            javaOut.print(";\n");
        }
        if (attributes.getLength() > 0) {
            javaOut.print('\n');
        }
    }

    private void printConstructors(NodeList constructors, String classname, PrintWriter javaOut) {
        int length = constructors.getLength();
        for (int i = 0; i < length; ++i) {
            Element constructor = (Element)constructors.item(i);
            this.printMethod(constructor, classname, "", javaOut);
        }
        if (constructors.getLength() > 0) {
            javaOut.print('\n');
        }
    }

    private void printMethods(NodeList methods, PrintWriter javaOut) {
        int length = methods.getLength();
        for (int i = 0; i < length; ++i) {
            Element method = (Element)methods.item(i);
            javaOut.print('\n');
            this.printMethod(method, method.getAttribute("name"), method.getAttribute("type"), javaOut);
        }
        if (methods.getLength() > 0) {
            javaOut.print('\n');
        }
    }

    private void printMethod(Element method, String name, String returnType, PrintWriter javaOut) {
        javaOut.print('\t' + method.getAttribute("visibility"));
        if (returnType.length() > 0) {
            javaOut.print(' ' + returnType);
        }
        javaOut.print(' ' + name + '(');
        NodeList parameters = method.getElementsByTagName("Parameter");
        int length = parameters.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)parameters.item(i);
            if (i > 0) {
                javaOut.print(", ");
            }
            javaOut.print(parameter.getAttribute("type") + ' ' + parameter.getAttribute("name"));
        }
        javaOut.print(')');
        NodeList exceptions = method.getElementsByTagName("Exception");
        length = exceptions.getLength();
        if (length > 0) {
            javaOut.print(" throws ");
        }
        for (int i = 0; i < length; ++i) {
            Element exception = (Element)exceptions.item(i);
            if (i > 0) {
                javaOut.print(", ");
            }
            javaOut.print(exception.getAttribute("type"));
        }
        javaOut.print(" {\n");
        NodeList lines = method.getElementsByTagName("Line");
        length = lines.getLength();
        for (int i = 0; i < length; ++i) {
            Element line = (Element)lines.item(i);
            if (line.getFirstChild() == null) {
                javaOut.println();
                continue;
            }
            javaOut.print("\t\t" + line.getFirstChild().getNodeValue() + '\n');
        }
        javaOut.print("\t}\n");
    }

    private void extractAsynchronousTrace(Element tables) throws TransformerException, IOException {
        Document asynchronousTrace = this.findAsynchronousTrace(tables);
        if (asynchronousTrace != null && asynchronousTrace.getDocumentElement().hasChildNodes()) {
            DomUtilities.serialize((File)new File(this.getUmlDocument().getDocumentWorkingFolder(), "asynchronous.trace.template"), (Document)asynchronousTrace, (boolean)true);
        }
    }

    private Document findAsynchronousTrace(Element tables) {
        Document result = null;
        ArrayList<Node> elementsToRemove = new ArrayList<Node>();
        NodeList asynchronousTraceElements = tables.getElementsByTagName("AsynchronousTrace");
        int length = asynchronousTraceElements.getLength();
        if (length > 0) {
            result = DomUtilities.newDocument((String)"AsynchronousTrace");
            for (int i = 0; i < length; ++i) {
                Node node = asynchronousTraceElements.item(i);
                NodeList children = node.getChildNodes();
                int childCount = children.getLength();
                for (int j = 0; j < childCount; ++j) {
                    Node child = children.item(j);
                    if (!(child instanceof Element)) continue;
                    Element importChild = (Element)result.importNode(child, true);
                    result.getDocumentElement().appendChild(importChild);
                }
                elementsToRemove.add(node);
            }
        }
        for (Node node : elementsToRemove) {
            node.getParentNode().removeChild(node);
        }
        return result;
    }

    private void extractLibraryInterface(Element tables) throws TransformerException, IOException, XPathExpressionException {
        NodeList idlNodes = tables.getElementsByTagName("IDL");
        if (idlNodes != null && idlNodes.getLength() > 0) {
            int length;
            Node libraryInterface = idlNodes.item(0);
            if (libraryInterface.getChildNodes().getLength() > 0) {
                Document interfaceDocument = DomUtilities.newDocument();
                Attr millis = (Attr)DomUtilities.evaluate((Node)tables, (String)"table/Revision/CompilerInformation/BuildTime/@millis", (NamespaceContext)null, (QName)XPathConstants.NODE);
                Element importedInterface = (Element)interfaceDocument.importNode(libraryInterface, true);
                importedInterface.setAttribute("buildID", millis.getValue());
                interfaceDocument.appendChild(importedInterface);
                DomUtilities.serialize((File)new File(this.getUmlDocument().getDocumentWorkingFolder(), "library.interface"), (Document)interfaceDocument, (boolean)true);
            }
            for (int i = length = idlNodes.getLength(); i > 0; --i) {
                tables.removeChild(idlNodes.item(i - 1));
            }
        }
    }

    @Override
    void setSource(Document source) {
        this.sourceDocument = source;
    }

    @Override
    long getResultLastModified() {
        if (this.getDest() != null) {
            return this.getDest().lastModified();
        }
        if (this.getUmlDocument() != null) {
            return this.getTargetFile(this.getUmlDocument()).lastModified();
        }
        return 0L;
    }
}

