/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.compiler.build.BuildErrorException;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.BeforeXSLTTask;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DefaultCompilerError;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.ZipUtilities;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Xmi2ExmiBeforeTask
extends BeforeXSLTTask {
    private File source;
    private String fileId;
    private File dest;

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        if (this.getUmlDocument() != null) {
            this.getErrorHandler().addTo((AbstractErrorHandler)this.getUmlDocument().getEXMIErrorHandler());
            this.getUmlDocument().getEXMIErrorHandler().serialize(false);
        }
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    private Document getSourceDocument() throws ParserConfigurationException, SAXException, IOException {
        File sourceFile = this.getSource();
        if (sourceFile != null && sourceFile.exists()) {
            try {
                ZipFile zipfile = new ZipFile(sourceFile);
                return ZipUtilities.getZippedDocumentFromFile((ZipFile)zipfile);
            }
            catch (IOException e) {
                return DomUtilities.parse((File)sourceFile, (boolean)false, (boolean)false, (boolean)false);
            }
        }
        return null;
    }

    public File getSource() {
        File source = this.source;
        if (source == null) {
            source = this.getSourceFromModelFile();
        }
        return source;
    }

    private File getSourceFromModelFile() {
        if (this.getUmlDocument() != null) {
            return this.getUmlDocument().getOriginalFile();
        }
        return null;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public String getFileId() {
        if (this.fileId != null) {
            return this.fileId;
        }
        if (this.getUmlDocument() != null) {
            return this.getUmlDocument().getUniqueId();
        }
        return "";
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        UmlDocument umlDocument = this.getUmlDocument();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (umlDocument != null) {
            parameters.put("document.name", umlDocument.getDocumentName());
            parameters.put("absolute path", umlDocument.getAbsolutePath());
            SendStatusEvent event = new SendStatusEvent((Object)this, "status.creating.bridge.xmi", parameters);
            EventController.fire((EventObject)event);
        }
        try {
            Document xmiDocument = this.getSourceDocument();
            xmiDocument.getDocumentElement().setAttribute("fileid", this.getFileId());
            Document bridgeXmiDocument = this.createBridgeXmi(xmiDocument);
            if (this.getDest() != null) {
                DomUtilities.serialize((File)this.getDest(), (Document)bridgeXmiDocument, (boolean)true);
            }
            this.printResult(bridgeXmiDocument);
        }
        catch (TransformerException ex) {
            throw new BuildException(ex);
        }
        catch (BuildErrorException beEx) {
            throw beEx;
        }
        catch (SAXParseException ex) {
            DefaultCompilerError error = new DefaultCompilerError("error.could.not.parse.document", parameters);
            this.getErrorHandler().error((AbstractBuilderError)error);
        }
        catch (Exception ex) {
            this.showFatalError(ex.getMessage() == null ? "null" : ex.getMessage());
            throw new BuildException(ex);
        }
        finally {
            if (umlDocument != null) {
                umlDocument.resetLastModified();
            }
        }
    }

    private Document createBridgeXmi(Document xmlDocument) throws IOException, ParserConfigurationException, SAXException, TransformerLoadException, TransformerException, XPathExpressionException {
        String namespace = xmlDocument.getDocumentElement().getAttribute("xmlns:xmi");
        Document bridgeXmiDocument = namespace.equals("http://schema.omg.org/spec/XMI/2.1") ? this.createBridgeXMI(xmlDocument) : this.createMD1705BridgeXmi(xmlDocument);
        return bridgeXmiDocument;
    }

    private Document createMD1705BridgeXmi(Document xmlDocument) {
        xmlDocument.getDocumentElement().setAttribute("xmlns:xmi", "http://schema.omg.org/spec/XMI/2.1");
        xmlDocument.getDocumentElement().setAttribute("xmlns:uml", "http://www.omg.org/spec/UML/20090901");
        xmlDocument.getDocumentElement().setAttribute("xmlns:MagicDraw_Profile", "http://www.magicdraw.com/schemas/MagicDraw_Profile.xmi");
        return xmlDocument;
    }

    private Document createBridgeXMI(Document xmlDocument) {
        String version = this.getXmiVersion(xmlDocument);
        if (version == null) {
            DefaultCompilerError error = new DefaultCompilerError("exmi.error.unsupported.xmi.file", new HashMap<String, String>());
            this.getErrorHandler().error((AbstractBuilderError)error);
        }
        return xmlDocument;
    }

    private String getXmiVersion(Document xmlDocument) {
        String version = null;
        Element root = xmlDocument.getDocumentElement();
        if (root.hasAttribute("xmi.version")) {
            version = root.getAttribute("xmi.version");
        } else if (root.hasAttribute("xmi:version")) {
            version = root.getAttribute("xmi:version");
        }
        return version;
    }

    @Override
    StreamSource getResultAsStreamSource() {
        if (this.getDest() != null && this.getDest().exists()) {
            return new StreamSource(this.getDest());
        }
        return null;
    }

    @Override
    long getSourceLastModified() {
        File sourceFile = this.getSource();
        if (sourceFile != null && sourceFile.exists()) {
            return sourceFile.lastModified();
        }
        return 0L;
    }
}

