/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.AfterXSLTTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.Library;
import ch.e2e.builder.compiler.descriptor.LibraryDeployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.ConfigurationError;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Xmi2DescriptorAfterTask
extends AfterXSLTTask {
    private static String scriptVersion = "0";
    private Document sourceDocument;
    private File dest;

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        if (this.getUmlDocument() != null) {
            this.getErrorHandler().addTo((AbstractErrorHandler)this.getUmlDocument().getEXMIErrorHandler());
            this.getUmlDocument().getEXMIErrorHandler().serialize(false);
        }
    }

    public Document getSourceDocument() {
        return this.sourceDocument;
    }

    public void setSourceDocument(Document sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public static String getScriptVersion() {
        return scriptVersion;
    }

    private File getDescriptorFolder(UmlDocument umlDocument) {
        return new File(umlDocument.getDocumentWorkingFolder(), "descriptor");
    }

    private File getDescriptorFile(UmlDocument umlDocument) {
        File descriptorFolder = this.getDescriptorFolder(umlDocument);
        return new File(descriptorFolder, "descriptor.xml");
    }

    @Override
    public void executeTask(int dependencyLevel) throws BuildException {
        UmlDocument umlDocument = this.getUmlDocument();
        if (umlDocument == null) {
            throw new BuildException("UmlDocument not defined for task: " + this.getClass().getSimpleName());
        }
        if (umlDocument.isDescriptorIncluded()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("document.name", umlDocument.getDocumentName());
            parameters.put("absolute path", umlDocument.getAbsolutePath());
            SendStatusEvent event = new SendStatusEvent((Object)this, "status.creating.descriptor", parameters);
            EventController.fire((EventObject)event);
            try {
                Document descriptorDocument = this.getSourceDocument();
                if (descriptorDocument == null) {
                    throw new BuildException("Unable to find source for compiler task: " + this.getClass().getSimpleName());
                }
                descriptorDocument.getDocumentElement().setAttribute("scriptversion", Xmi2DescriptorAfterTask.getScriptVersion());
                DomUtilities.serialize((File)this.getDescriptorFile(umlDocument), (Document)descriptorDocument, (boolean)false);
                this.setDescriptor(umlDocument, descriptorDocument);
                this.writeDeploymentFiles(descriptorDocument, this.getDescriptorFolder(umlDocument));
            }
            catch (Exception e) {
                this.showFatalError(e.getMessage());
                this.getErrorHandler().error((Throwable)e);
                Logging.logger.throwing(this.getClass().getName(), "executeTask", e);
            }
        }
    }

    private void setDescriptor(UmlDocument umlDocument, Document descriptorDocument) {
        if (descriptorDocument == null) {
            umlDocument.setDescriptorIncluded(false);
        } else {
            umlDocument.setDescriptorDocument(descriptorDocument);
            umlDocument.getDescriptor().distributeErrors(this.getErrorHandler());
            try {
                this.writeInstanceList(umlDocument);
            }
            catch (IOException e) {
                this.getErrorHandler().error((Throwable)e);
                throw new BuildException("Error writing instance list.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInstanceList(UmlDocument umlDocument) throws IOException {
        File folder = umlDocument.getDocumentWorkingFolder();
        String filename = umlDocument.getUniqueId() + ".instance.list";
        File instanceList = new File(folder, filename);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(instanceList));
            for (Composite composite : umlDocument.getDescriptor().getComposites()) {
                out.println(composite.getName());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void writeDeploymentFiles(Document descriptorTemplate, File descriptorFolder) throws IOException, TransformerException, XPathExpressionException {
        int i;
        NodeList result = (NodeList)DomUtilities.evaluate((Node)descriptorTemplate.getDocumentElement(), (String)"//ModuleDescriptor/Module", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        ArrayList<Element> libraries = new ArrayList<Element>();
        int length = result.getLength();
        for (i = 0; i < length; ++i) {
            libraries.add((Element)result.item(i));
        }
        result = (NodeList)DomUtilities.evaluate((Node)descriptorTemplate.getDocumentElement(), (String)"//LibraryDescriptor/Library", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        length = result.getLength();
        for (i = 0; i < length; ++i) {
            libraries.add((Element)result.item(i));
        }
        NodeList deployments = (NodeList)DomUtilities.evaluate((Node)descriptorTemplate.getDocumentElement(), (String)"//Deployments/Deployment", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        if (deployments.getLength() == 0 && libraries.size() == 1) {
            this.appendLibraryDeployments(libraries, descriptorFolder);
        } else {
            this.addDeployments(descriptorTemplate, deployments, libraries, descriptorFolder);
        }
    }

    private void appendLibraryDeployments(List<Element> modules, File descriptorFolder) throws TransformerException, IOException {
        Element moduleElement = modules.get(0);
        Document deploymentDocument = DomUtilities.newDocument((String)"Deployment");
        LibraryDeployment deployment = new LibraryDeployment(moduleElement.getAttribute("name"));
        deploymentDocument.getDocumentElement().setAttribute("name", deployment.getName());
        Element configurationsElement = deploymentDocument.createElement("Configurations");
        deploymentDocument.getDocumentElement().appendChild(configurationsElement);
        Element modulesElement = deploymentDocument.createElement("Libraries");
        deploymentDocument.getDocumentElement().appendChild(modulesElement);
        modulesElement.appendChild(deploymentDocument.importNode(moduleElement, true));
        File descriptorFile = new File(descriptorFolder, ((Deployment)deployment).getFilename());
        DomUtilities.serialize((File)descriptorFile, (Document)deploymentDocument, (boolean)true);
    }

    private void addDeployments(Document descriptorTemplate, NodeList deployments, List<Element> libraries, File descriptorFolder) throws TransformerException, IOException, XPathExpressionException {
        boolean moduleDescriptorWritten = false;
        NodeList configurations = (NodeList)DomUtilities.evaluate((Node)descriptorTemplate.getDocumentElement(), (String)"//Configurations/Configuration", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        int length = deployments.getLength();
        for (int i = 0; i < length; ++i) {
            Element deploymentElement = (Element)deployments.item(i);
            Deployment deployment = null;
            Document deploymentDocument = DomUtilities.newDocument((String)"Deployment");
            deploymentDocument.getDocumentElement().setAttribute("name", deploymentElement.getAttribute("name"));
            Element configurationsElement = deploymentDocument.createElement("Configurations");
            deploymentDocument.getDocumentElement().appendChild(configurationsElement);
            int configLength = configurations.getLength();
            for (int j = 0; j < configLength && deployment == null; ++j) {
                Element configurationElement = (Element)configurations.item(j);
                Node deployedInstance = (Node)DomUtilities.evaluate((Node)deploymentElement, (String)("Node/DeployedInstance[@idref='" + configurationElement.getAttribute("id") + "']"), (NamespaceContext)null, (QName)XPathConstants.NODE);
                if (deployedInstance == null) continue;
                Composite composite = new Composite(configurationElement, this.getUmlDocument());
                configurationsElement.appendChild(deploymentDocument.importNode(configurationElement, true));
                this.checkBackendsAndProxies(configurationElement, deploymentElement);
                deployment = new Deployment(deploymentElement, (CompilableObject)composite);
            }
            Element librariesElement = deploymentDocument.createElement("Libraries");
            deploymentDocument.getDocumentElement().appendChild(librariesElement);
            int librariesLength = libraries.size();
            for (int j = 0; j < librariesLength && deployment == null; ++j) {
                Element libraryElement = libraries.get(j);
                if (!this.containsLibrary(deploymentElement, libraryElement)) continue;
                Library library = new Library(libraryElement, this.getUmlDocument());
                librariesElement.appendChild(deploymentDocument.importNode(libraryElement, true));
                this.checkBackendsAndProxies(libraryElement, deploymentElement);
                deployment = new Deployment(deploymentElement, (CompilableObject)library);
                moduleDescriptorWritten = true;
            }
            if (deployment == null) {
                deployment = new Deployment(deploymentElement, null);
            }
            this.replaceHostInfo(deploymentDocument, deployment);
            File descriptorFile = new File(descriptorFolder, deployment.getFilename());
            DomUtilities.serialize((File)descriptorFile, (Document)deploymentDocument, (boolean)true);
        }
        if (libraries.size() == 1 && !moduleDescriptorWritten) {
            this.appendLibraryDeployments(libraries, descriptorFolder);
        }
    }

    private void checkBackendsAndProxies(Element configurationElement, Element deploymentElement) throws XPathExpressionException {
        NodeList deployedInstances = (NodeList)DomUtilities.evaluate((Node)deploymentElement, (String)"Node/DeployedInstance", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        this.checkBackends(configurationElement, deploymentElement, deployedInstances);
        this.checkProxies(configurationElement, deploymentElement, deployedInstances);
    }

    private void checkBackends(Element configurationElement, Element deploymentElement, NodeList deployedInstances) throws XPathExpressionException {
        NodeList aliases = (NodeList)DomUtilities.evaluate((Node)configurationElement, (String)"Aliases/Alias", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        int length = aliases.getLength();
        for (int i = 0; i < length; ++i) {
            Element alias = (Element)aliases.item(i);
            boolean aliasMissing = true;
            NodeList artifacts = alias.getElementsByTagName("DeployedServiceArtifact");
            if (artifacts.getLength() != 1) continue;
            Element artifact = (Element)artifacts.item(0);
            String id = artifact.getAttribute("id");
            int instancesLength = deployedInstances.getLength();
            for (int j = 0; j < instancesLength && aliasMissing; ++j) {
                aliasMissing = !((Element)deployedInstances.item(j)).getAttribute("idref").equals(id);
            }
            if (!aliasMissing) continue;
            this.addError("error.backend.service.not.found.in.deployment", configurationElement, deploymentElement, artifact.getAttribute("umlLocation"), artifact.getAttribute("name"), "service name");
        }
    }

    private void addError(String errorCode, Element configurationElement, Element deploymentElement, String umlLocation, String name, String nameKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String configuration = configurationElement.getAttribute("name");
        parameters.put("composite.name", configuration);
        parameters.put("deployment.name", deploymentElement.getAttribute("name"));
        parameters.put(nameKey, name);
        ConfigurationError error = new ConfigurationError(errorCode, parameters, umlLocation, configuration);
        this.getErrorHandler().error((AbstractBuilderError)error);
    }

    private void checkProxies(Element configurationElement, Element deploymentElement, NodeList deployedInstances) throws XPathExpressionException {
        NodeList proxies = (NodeList)DomUtilities.evaluate((Node)configurationElement, (String)"Proxies/Proxy", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        int length = proxies.getLength();
        for (int i = 0; i < length; ++i) {
            Element proxy = (Element)proxies.item(i);
            boolean proxyMissing = true;
            String id = proxy.getAttribute("id");
            int instancesLength = deployedInstances.getLength();
            for (int j = 0; j < instancesLength && proxyMissing; ++j) {
                proxyMissing = !((Element)deployedInstances.item(j)).getAttribute("idref").equals(id);
            }
            if (!proxyMissing) continue;
            this.addError("error.proxy.service.not.found.in.deployment", configurationElement, deploymentElement, proxy.getAttribute("umlLocation"), proxy.getAttribute("name"), "service name");
        }
    }

    private boolean containsLibrary(Element deploymentElement, Element libraryElement) throws XPathExpressionException {
        NodeList attributes = (NodeList)DomUtilities.evaluate((Node)libraryElement, (String)"//Module//@deployedArtifact, //Library//@deployedArtifact, //Module//@id, //Library//@id", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        ArrayList<String> ids = new ArrayList<String>();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attributes.item(i);
            ids.add(attr.getValue());
        }
        length = ids.size();
        boolean result = deploymentElement.getAttribute("components").equals(libraryElement.getAttribute("id"));
        for (int i = 0; i < length && !result; ++i) {
            result = DomUtilities.evaluate((Node)deploymentElement, (String)("Node/DeployedInstance[@idref='" + libraryElement.getAttribute("id") + "']"), (NamespaceContext)null, (QName)XPathConstants.NODE) != null;
        }
        return result;
    }

    private void replaceHostInfo(Document document, Deployment deployment) {
        this.replaceHostInfoConfiguration(document.getElementsByTagName("Configuration"), deployment);
        this.replaceHostInfoConfiguration(document.getElementsByTagName("Library"), deployment);
    }

    private void replaceHostInfoConfiguration(NodeList children, Deployment deployment) {
        if (children.getLength() == 1) {
            Element configurationElement = (Element)children.item(0);
            String host = deployment.getHost(configurationElement.getAttribute("id"));
            configurationElement.setAttribute("host", host);
            this.replaceHostInfo(configurationElement.getChildNodes(), deployment);
        }
    }

    private void replaceHostInfo(NodeList children, Deployment deployment) {
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.replaceHostInfo((Element)child, deployment);
        }
    }

    private void replaceHostInfo(Element element, Deployment deployment) {
        String id = element.getAttribute("id");
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getValue().contains("deployedHost")) continue;
            element.setAttribute(attribute.getName(), this.replaceHostInfo(attribute.getValue(), deployment, id));
        }
        this.replaceHostInfo(element.getChildNodes(), deployment);
    }

    private String replaceHostInfo(String value, Deployment deployment, String id) {
        value = deployment.replaceHostInfo(value, id);
        return value;
    }

    @Override
    void setSource(Document source) {
        this.sourceDocument = source;
    }

    @Override
    long getResultLastModified() {
        if (this.getDest() != null) {
            return this.getDest().lastModified();
        }
        if (this.getUmlDocument() != null) {
            return this.getDescriptorFile(this.getUmlDocument()).lastModified();
        }
        return 0L;
    }

    @Override
    public boolean isUpToDate() {
        boolean result = false;
        if (this.getUmlDocument() != null) {
            result = !this.getUmlDocument().isDescriptorIncluded();
        }
        return result;
    }
}

