/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.tools.TransformerFactory;
import ch.e2e.builder.compiler.xsltinterface.Cache;
import ch.e2e.builder.compiler.xsltinterface.XSLTOutput;
import ch.e2e.dom.DomUtilities;
import ch.e2e.transformer.TransformerLoadException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XSLTTask
extends CacheAbleTask
implements XSLTTransformSource {
    private static int taskIdCounter = 0;

    public XSLTTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._xml;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.transform(this.getTransformSource(), new StreamResult(this.getDestinationFile()));
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
        System.gc();
    }

    protected boolean isSingleSource() {
        return false;
    }

    protected javax.xml.transform.Source getTransformSource() throws Exception {
        Set<String> sourceSet = this.getSourceSet();
        if (this.isSingleSource()) {
            return ((XSLTTransformSource)this.getSource(sourceSet.iterator().next())).getXSLTTransformSource();
        }
        Document document = DomUtilities.newDocument((String)"http://scheer-group.com/xuml", (String)"xuml:sources");
        Element sources = document.getDocumentElement();
        sources.setAttribute("id", this.getId());
        sources.setAttribute("folder", this.getDestinationFolder());
        sources.setAttribute("name", this.getDestinationFileName());
        sources.setAttribute("extension", this.getDestinationFileExtension());
        sources.setAttribute("nameWithoutExtension", this.getDestinationFileNameWithoutExtension());
        Element paramters = document.createElementNS("http://scheer-group.com/xuml", "xuml:parameters");
        for (Map.Entry<String, Object> entry : this.getTransformParameters().entrySet()) {
            paramters.setAttribute(entry.getKey(), entry.getValue().toString());
        }
        sources.appendChild(paramters);
        for (String sourceKey : sourceSet) {
            Element source = document.createElementNS("http://scheer-group.com/xuml", "xuml:source");
            sources.appendChild(source);
            source.setAttribute("id", sourceKey);
            if (sourceKey.lastIndexOf(Folders.SEPARATOR) >= 0) {
                source.setAttribute("folder", sourceKey.substring(0, sourceKey.lastIndexOf(Folders.SEPARATOR)));
                source.setAttribute("name", sourceKey.substring(sourceKey.lastIndexOf(Folders.SEPARATOR) + 1));
            } else {
                source.setAttribute("folder", "");
                source.setAttribute("name", sourceKey);
            }
            Source taskSource = this.getSource(sourceKey);
            if (taskSource instanceof XSLTTransformSource) {
                Node node = XSLTTransformSource.getNode(((XSLTTransformSource)taskSource).getXSLTTransformSource());
                Node element = node instanceof Document ? ((Document)node).getDocumentElement() : (Element)node;
                element = document.importNode(element, true);
                source.appendChild(element);
                continue;
            }
            if (!(taskSource instanceof InputStreamSource)) continue;
            Element json = document.createElementNS("http://scheer-group.com/xuml", "xuml:text");
            InputStream inputStream = ((InputStreamSource)taskSource).getInputStream();
            json.setTextContent(new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n")));
            source.appendChild(json);
        }
        if (Boolean.getBoolean("ch.e2e.builder.development") || this.isDebug().booleanValue()) {
            try {
                DomUtilities.serialize((File)new File(this.getDestinationFile().getPath() + Extensions._sources), (Document)document, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DOMSource(document);
    }

    protected abstract String getTransformerId();

    private Transformer getTransformer(String transformerId) throws TransformerLoadException {
        return TransformerFactory.getInstance().getTransformer(transformerId);
    }

    protected Map<String, Object> getTransformParameters() {
        return new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transform(javax.xml.transform.Source source, Result result) throws TransformerLoadException {
        Transformer transformer = this.getTransformer(this.getTransformerId());
        String taskId = "XSLTTask-" + taskIdCounter++;
        XSLTErrorHandler xsltErrorHandler = XSLTOutput.addXsltErrorHandler((String)taskId);
        transformer.setParameter("taskId", taskId);
        for (Map.Entry<String, Object> entry : this.getTransformParameters().entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
        try {
            transformer.transform(source, result);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
            Logging.logger.throwing(this.getClass().getName(), "executeTask", e);
        }
        finally {
            xsltErrorHandler.addTo(this.getErrorHandler());
            XSLTOutput.removeXsltErorHandler((String)taskId);
            Cache.deleteTaskCaches(taskId);
        }
    }

    @Override
    public javax.xml.transform.Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

