/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.AfterXSLTTask;
import ch.e2e.builder.compiler.build.tasks.BeforeXSLTTask;
import ch.e2e.builder.compiler.build.tasks.CompilerTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.tools.TransformerFactory;
import ch.e2e.builder.compiler.xsltinterface.Cache;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.builder.compiler.xsltinterface.XSLTOutput;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.logging.PerformanceLogger;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XSLTCompilerTask
extends CompilerTask {
    private static int taskIdCounter = 0;
    private BeforeXSLTTask beforeXSLTTask;
    private AfterXSLTTask afterXSLTTask;
    private File source;
    private File dest;
    private DOMResult result;

    public XSLTCompilerTask() {
        super(new CompileControl[0]);
    }

    protected abstract String getStatusMessageCode();

    protected abstract String getTransformerId();

    protected abstract File getDefaultSource();

    @Override
    public void setUmlDocument(UmlDocument umlDocument) {
        super.setUmlDocument(umlDocument);
        if (this.beforeXSLTTask != null) {
            this.beforeXSLTTask.setUmlDocument(umlDocument);
        }
        if (this.afterXSLTTask != null) {
            this.afterXSLTTask.setUmlDocument(umlDocument);
        }
    }

    public File getSource() {
        if (this.source != null) {
            return this.source;
        }
        return this.getDefaultSource();
    }

    public void setSource(File source) {
        this.source = source;
    }

    public File getDest() {
        return this.dest;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    void setBeforeXSLTTask(BeforeXSLTTask beforeXSLTTask) {
        this.beforeXSLTTask = beforeXSLTTask;
    }

    void setAfterXSLTTask(AfterXSLTTask afterXSLTTask) {
        this.afterXSLTTask = afterXSLTTask;
    }

    public DOMResult getResult() {
        return this.result;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        UmlDocument umlDocument = this.getUmlDocument();
        String sourceName = "";
        if (umlDocument != null) {
            sourceName = umlDocument.getName();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("document.name", umlDocument.getDocumentName());
            parameters.put("absolute path", umlDocument.getAbsolutePath());
            SendStatusEvent event = new SendStatusEvent((Object)this, this.getStatusMessageCode(), parameters);
            EventController.fire((EventObject)event);
        }
        try {
            long start = PerformanceLogger.start((String)(this.getCompilerId() + ".transform"), (String)sourceName);
            StreamSource streamSource = null;
            if (this.getSource() != null) {
                streamSource = new StreamSource(this.getSource());
            }
            if (this.beforeXSLTTask != null) {
                this.beforeXSLTTask.execute(dependencyLevel);
                if (this.beforeXSLTTask.getErrorHandler().getErrorCount() > 0) {
                    return;
                }
                streamSource = this.beforeXSLTTask.getResultAsStreamSource();
            }
            if (streamSource == null) {
                throw new BuildException("Unable to find source for xslt compiler task: " + this.getClass().getSimpleName());
            }
            this.result = this.transform(streamSource);
            this.printResult(this.result.getNode());
            if (this.getDest() != null) {
                DomUtilities.serialize((File)this.getDest(), (Node)this.result.getNode(), (boolean)true);
            }
            if (this.getErrorHandler().getErrorCount() == 0 && this.afterXSLTTask != null) {
                this.afterXSLTTask.setSource((Document)this.result.getNode());
                this.afterXSLTTask.execute(dependencyLevel);
            }
            PerformanceLogger.stop((String)(this.getCompilerId() + ".transform"), (String)sourceName, (long)start);
        }
        catch (TransformerException ex) {
            throw new BuildException(ex);
        }
        catch (Exception ex) {
            this.showFatalError(ex.getMessage() == null ? "null" : ex.getMessage());
            throw new BuildException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DOMResult transform(StreamSource streamSource) throws TransformerException, TransformerLoadException, IOException {
        DOMResult result = new DOMResult();
        Transformer transformer = this.getTransformer(this.getTransformerId());
        String taskId = "XSLTCompilerTask-" + taskIdCounter++;
        XSLTErrorHandler xsltErrorHandler = XSLTOutput.addXsltErrorHandler((String)taskId);
        XSLTInput.setCurrentXmiFile(this.getUmlDocument(), taskId);
        transformer.setParameter("taskId", taskId);
        try {
            transformer.transform(streamSource, result);
        }
        catch (Exception e) {
            this.showFatalError(e.getMessage());
            this.getErrorHandler().error((Throwable)e);
            Logging.logger.throwing(this.getClass().getName(), "executeTask", e);
        }
        finally {
            xsltErrorHandler.addTo(this.getErrorHandler());
            XSLTOutput.removeXsltErorHandler((String)taskId);
            Cache.deleteTaskCaches(taskId);
            XSLTInput.removeCurentXmiFile(taskId);
        }
        return result;
    }

    private Transformer getTransformer(String transformerId) throws TransformerLoadException {
        return TransformerFactory.getInstance().getTransformer(transformerId);
    }

    @Override
    public boolean isUpToDate() {
        long sourceLastModified = 0L;
        if (this.beforeXSLTTask != null) {
            sourceLastModified = this.beforeXSLTTask.getSourceLastModified();
        } else if (this.getSource() != null && this.getSource().exists()) {
            sourceLastModified = this.getSource().lastModified();
        }
        if (sourceLastModified == 0L) {
            return false;
        }
        long resultLastModified = 0L;
        if (this.afterXSLTTask != null) {
            resultLastModified = this.afterXSLTTask.getResultLastModified();
        } else if (this.getDest() != null && this.getDest().exists()) {
            resultLastModified = this.getDest().lastModified();
        }
        return resultLastModified > sourceLastModified;
    }
}

