/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.BuildErrorException;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.BuildProperties;
import ch.e2e.builder.compiler.build.CompilationProperties;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.AggregateCompileControl;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.tasks.control.CompileControlFactory;
import ch.e2e.builder.compiler.build.tasks.control.TaskInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;

public abstract class Task {
    private final Set<Task> dependsOnTasks = new HashSet<Task>();
    private boolean isExecuted = false;
    private final TaskInfo taskInfo = new TaskInfo(this.getName());
    protected final AggregateCompileControl compileControl;
    private Boolean debug = false;

    protected Task(CompileControl ... controls) {
        List<CompileControl> compileControls = Optional.ofNullable(controls).map(Arrays::asList).orElse(Collections.singletonList(new CompileControl()));
        this.compileControl = new AggregateCompileControl(compileControls);
    }

    public void addDependsOnTask(Task task) {
        this.dependsOnTasks.add(task);
    }

    public Iterator<Task> getDependsOnTasksIterator() {
        return this.dependsOnTasks.iterator();
    }

    public abstract AbstractErrorHandler getErrorHandler();

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    protected Boolean isDebug() {
        return this.debug;
    }

    public final void execute() throws BuildException {
        this.logDependencies();
        this.execute(0);
    }

    protected void afterExecute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(int dependencyLevel) throws BuildException {
        block10: {
            try {
                this.compileControl.onTaskRequested(this.taskInfo, dependencyLevel);
                AbstractErrorHandler dependsTasksErrors = this.executeDependsOnTasks(dependencyLevel);
                if (this.compileControl.shouldAbortTask(this.taskInfo, dependencyLevel)) {
                    this.compileControl.onTaskAbort(this.taskInfo, dependencyLevel);
                    return;
                }
                if (dependsTasksErrors.getErrorAndWarningCount() > 0 || !this.isUpToDateWrapper() || Boolean.getBoolean("ch.e2e.builder.devCleanAll") || Boolean.getBoolean("ch.e2e.builder.devCleanTask." + this.getClass().getSimpleName())) {
                    this.getErrorHandler().clear(true);
                    this.taskInfo.setStartTime(new Date());
                    this.taskInfo.setErrorHandler(this.getErrorHandler());
                    try {
                        this.getErrorHandler().clear(true);
                        dependsTasksErrors.addTo(this.getErrorHandler());
                        if (!this.getErrorHandler().hasErrors()) {
                            this.compileControl.onTaskBeforeExecute(this.taskInfo, dependencyLevel);
                            this.executeTask(dependencyLevel);
                        }
                    }
                    catch (Exception ex) {
                        this.compileControl.onTaskException(this.taskInfo, dependencyLevel);
                        if (!(ex instanceof BuildErrorException)) {
                            Logging.logger.throwing(this.getClass().getName(), "execute", ex);
                        }
                        this.getErrorHandler().error((Throwable)ex);
                    }
                    this.propagateErrors();
                    this.afterExecute();
                    this.taskInfo.setEndTime(new Date());
                    this.compileControl.onTaskAfterExecute(this.taskInfo, dependencyLevel);
                    break block10;
                }
                this.compileControl.onTaskUpToDate(this.taskInfo, dependencyLevel);
            }
            finally {
                this.isExecuted = true;
                this.compileControl.onTaskExecuted(this.taskInfo, dependencyLevel);
            }
        }
    }

    protected abstract void executeTask(int var1) throws BuildException;

    protected String getProperty(String key) {
        return BuildProperties.getInstance().getString(key);
    }

    public static String getCompilationProperty(String key) {
        return CompilationProperties.getInstance().getString(key);
    }

    public abstract String getTaskSourceName();

    protected abstract void propagateErrors();

    public boolean isUpToDate() {
        return false;
    }

    public boolean isUpToDateWrapper() {
        if (CompileControlFactory.tracingEnabled()) {
            this.taskInfo.getCacheInfo().setStartTime(new Date());
            boolean isUpToDate = this.isUpToDate();
            this.taskInfo.getCacheInfo().setEndTime(new Date());
            this.taskInfo.getCacheInfo().setUpToDate(isUpToDate);
            return isUpToDate;
        }
        return this.isUpToDate();
    }

    public boolean isExecuted() {
        return this.isExecuted;
    }

    protected AbstractErrorHandler executeDependsOnTasks(int dependencyLevel) {
        AbstractErrorHandler errorHandler = new AbstractErrorHandler(){};
        for (Task task : this.dependsOnTasks) {
            if (!task.isExecuted()) {
                if (this.compileControl.shouldAbortTask(this.taskInfo, dependencyLevel)) break;
                task.execute(dependencyLevel + 1);
            } else {
                this.compileControl.onTaskAlreadyExecuted(this.taskInfo, dependencyLevel);
            }
            task.getErrorHandler().addTo(errorHandler);
        }
        return errorHandler;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void logDependencies() {
        this.logDependencies(0);
    }

    private void logDependencies(int level) {
        if (Logging.logger.isLoggable(Level.FINER)) {
            StringBuilder message = new StringBuilder("*** ");
            for (int i = 0; i < level; ++i) {
                message.append(" ");
            }
            if (!this.dependsOnTasks.isEmpty()) {
                message.append(this.getName()).append(" depends on:");
                Logging.logger.finer(message.toString());
                ++level;
                for (Task task : this.dependsOnTasks) {
                    task.logDependencies(level);
                }
            } else {
                message.append(this.getName());
                Logging.logger.finer(message.toString());
            }
        }
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }
}

